/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.common.Config;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageDesc {
    private static final Logger LOG = LoggerFactory.getLogger(StorageBackend.class);
    public static final String HADOOP_JOB_UGI = "hadoop.job.ugi";
    public static final String HADOOP_JOB_GROUP_NAME = "hadoop.job.group.name";
    public static final String USER_NAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String FS_DEFAULT_NAME = "fs.default.name";
    public static final String FS_HDFS_IMPL = "fs.hdfs.impl";
    public static final String FS_AFS_IMPL = "fs.afs.impl";
    public static final String DFS_AGENT_PORT = "dfs.agent.port";
    public static final String DFS_CLIENT_AUTH_METHOD = "dfs.client.auth.method";
    public static final String BOS_ENDPOINT = "bos_endpoint";
    public static final String BOS_ACCESS_KEY = "bos_accesskey";
    public static final String BOS_SECRET_ACCESS_KEY = "bos_secret_accesskey";
    public static final String FS_BOS_IMPL = "fs.bos.impl";
    public static final String FS_BOS_ACCESS_KEY = "fs.bos.access.key";
    public static final String FS_BOS_SECRET_ACCESS_KEY = "fs.bos.secret.access.key";
    public static final String FS_BOS_ENDPOINT = "fs.bos.endpoint";
    public static final String FS_BOS_MULTIPART_UPLOADS_BLOCK_SIZE = "fs.bos.multipart.uploads.block.size";
    protected StorageBackend.StorageType storageType;
    protected Map<String, String> properties;
    protected String name;
    protected boolean convertedToS3 = false;

    protected void tryConvertToS3() {
        if (!Config.enable_access_file_without_broker || this.storageType != StorageBackend.StorageType.BROKER) {
            return;
        }
        CaseInsensitiveMap ciProperties = new CaseInsensitiveMap();
        ciProperties.putAll(this.properties);
        if (StringUtils.isNotEmpty((CharSequence)ciProperties.get((Object)BOS_ENDPOINT).toString()) && StringUtils.isNotEmpty((CharSequence)ciProperties.get((Object)BOS_ACCESS_KEY).toString()) && StringUtils.isNotEmpty((CharSequence)ciProperties.get((Object)BOS_SECRET_ACCESS_KEY).toString())) {
            String bosEndpiont = ciProperties.get((Object)BOS_ENDPOINT).toString();
            try {
                URI uri = new URI(bosEndpiont);
                String host = uri.getHost();
                String[] hostSplit = host.split("\\.");
                if (hostSplit.length < 3) {
                    return;
                }
                String region = hostSplit[0];
                String s3Endpoint = new URIBuilder(uri).setHost("s3." + host).build().toString();
                this.properties.clear();
                this.properties.put("AWS_ENDPOINT", s3Endpoint);
                this.properties.put("AWS_REGION", region);
                this.properties.put("AWS_ACCESS_KEY", ciProperties.get((Object)BOS_ACCESS_KEY).toString());
                this.properties.put("AWS_SECRET_KEY", ciProperties.get((Object)BOS_SECRET_ACCESS_KEY).toString());
                this.storageType = StorageBackend.StorageType.S3;
                this.convertedToS3 = true;
                LOG.info("skip BROKER and access S3 directly.");
            }
            catch (URISyntaxException e) {
                LOG.warn("bos_endpoint: " + bosEndpiont + " is invalid.");
            }
        }
    }

    protected String convertPathToS3(String path) {
        if (!this.convertedToS3) {
            return path;
        }
        try {
            URI orig = new URI(path);
            URI s3url = new URI("s3", orig.getRawAuthority(), orig.getRawPath(), orig.getRawQuery(), orig.getRawFragment());
            return s3url.toString();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }
}

