/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.StorageDesc;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.thrift.TStorageBackendType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBackend
extends StorageDesc
implements ParseNode {
    private static final Logger LOG = LoggerFactory.getLogger(StorageBackend.class);
    private String location;
    private StorageType storageType;
    private Map<String, String> properties;

    public StorageBackend(String storageName, String location, StorageType storageType, Map<String, String> properties) {
        this.name = storageName;
        this.location = location;
        this.storageType = storageType;
        this.properties = properties;
        this.tryConvertToS3();
        this.location = this.convertPathToS3(location);
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    public String getStorageName() {
        return this.name;
    }

    public void setStorageName(String storageName) {
        this.name = storageName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (this.storageType != StorageType.BROKER && StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = this.storageType.name();
        }
        if (this.storageType != StorageType.BROKER && this.storageType != StorageType.S3) {
            throw new NotImplementedException(this.storageType.toString() + " is not support now.");
        }
        FeNameFormat.checkCommonName("repository", this.name);
        if (Strings.isNullOrEmpty((String)this.location)) {
            throw new AnalysisException("You must specify a location on the repository");
        }
        this.location = ExportStmt.checkPath(this.location, this.storageType);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.storageType.name());
        if (this.storageType == StorageType.BROKER) {
            sb.append(" `").append(this.name).append("`");
        }
        sb.append(" ON LOCATION ").append(this.location).append(" PROPERTIES(").append(new PrintableMap<String, String>(this.properties, " = ", true, false)).append(")");
        return sb.toString();
    }

    public static enum StorageType {
        BROKER("Doris Broker"),
        S3("Amazon S3 Simple Storage Service"),
        HDFS("Hadoop Distributed File System"),
        LOCAL("Local file system");

        private final String description;

        private StorageType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public TStorageBackendType toThrift() {
            switch (this) {
                case S3: {
                    return TStorageBackendType.S3;
                }
                case HDFS: {
                    return TStorageBackendType.HDFS;
                }
                case LOCAL: {
                    return TStorageBackendType.LOCAL;
                }
            }
            return TStorageBackendType.BROKER;
        }
    }
}

