/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.ExistsPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FromClause;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.GroupByClause;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SetOperationStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.TableAliasGenerator;
import org.apache.doris.common.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(StmtRewriter.class);

    public static StatementBase rewrite(Analyzer analyzer, StatementBase parsedStmt) throws AnalysisException {
        if (parsedStmt instanceof QueryStmt) {
            QueryStmt analyzedStmt = (QueryStmt)parsedStmt;
            Preconditions.checkNotNull((Object)analyzedStmt.analyzer);
            return StmtRewriter.rewriteQueryStatement(analyzedStmt, analyzer);
        }
        if (!(parsedStmt instanceof InsertStmt)) {
            throw new AnalysisException("Unsupported statement containing subqueries: " + parsedStmt.toSql());
        }
        InsertStmt insertStmt = (InsertStmt)parsedStmt;
        QueryStmt analyzedStmt = insertStmt.getQueryStmt();
        Preconditions.checkNotNull((Object)analyzedStmt.analyzer);
        QueryStmt rewrittenQueryStmt = StmtRewriter.rewriteQueryStatement(analyzedStmt, analyzer);
        insertStmt.setQueryStmt(rewrittenQueryStmt);
        return parsedStmt;
    }

    public static QueryStmt rewriteQueryStatement(QueryStmt stmt, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)stmt);
        if (stmt instanceof SelectStmt) {
            return StmtRewriter.rewriteSelectStatement((SelectStmt)stmt, analyzer);
        }
        if (!(stmt instanceof SetOperationStmt)) {
            throw new AnalysisException("Subqueries not supported for " + stmt.getClass().getSimpleName() + " statements");
        }
        StmtRewriter.rewriteUnionStatement((SetOperationStmt)stmt, analyzer);
        return stmt;
    }

    private static SelectStmt rewriteSelectStatement(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
        SelectStmt result = stmt;
        for (TableRef tblRef : result.fromClause_) {
            if (!(tblRef instanceof InlineViewRef)) continue;
            InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
            QueryStmt rewrittenQueryStmt = StmtRewriter.rewriteQueryStatement(inlineViewRef.getViewStmt(), inlineViewRef.getAnalyzer());
            inlineViewRef.setViewStmt(rewrittenQueryStmt);
        }
        if (result.hasWhereClause()) {
            result.whereClause = Expr.pushNegationToOperands(result.whereClause);
            if (StmtRewriter.hasSubqueryInDisjunction(result.whereClause)) {
                throw new AnalysisException("Subqueries in OR predicates are not supported: " + result.whereClause.toSql());
            }
            StmtRewriter.rewriteWhereClauseSubqueries(result, analyzer);
        }
        if (result.getHavingClauseAfterAnaylzed() != null && result.getHavingClauseAfterAnaylzed().getSubquery() != null) {
            result = StmtRewriter.rewriteHavingClauseSubqueries(result, analyzer);
        }
        result.sqlString_ = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("rewritten stmt: " + result.toSql());
        }
        return result;
    }

    private static SelectStmt rewriteHavingClauseSubqueries(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
        SelectList selectList = stmt.getSelectList();
        List columnLabels = stmt.getColLabels();
        Expr havingClause = stmt.getHavingClauseAfterAnaylzed();
        ArrayList<FunctionCallExpr> aggregateExprs = stmt.getAggInfo().getAggregateExprs();
        Preconditions.checkState((havingClause != null ? 1 : 0) != 0);
        Preconditions.checkState((havingClause.getSubquery() != null ? 1 : 0) != 0);
        List<OrderByElement> orderByElements = stmt.getOrderByElementsAfterAnalyzed();
        LimitElement limitElement = new LimitElement(stmt.getOffset(), stmt.getLimit());
        TableAliasGenerator tableAliasGenerator = stmt.getTableAliasGenerator();
        SelectStmt inlineViewQuery = (SelectStmt)stmt.clone();
        inlineViewQuery.reset();
        inlineViewQuery.removeHavingClause();
        inlineViewQuery.removeOrderByElements();
        inlineViewQuery.removeLimitElement();
        SelectList selectListOfInlineViewQuery = StmtRewriter.addMissingAggregationColumns(selectList, aggregateExprs);
        inlineViewQuery.setSelectList(selectListOfInlineViewQuery);
        ArrayList colAliasOfInlineView = Lists.newArrayList();
        ArrayList leftExprList = Lists.newArrayList();
        for (int i = 0; i < selectListOfInlineViewQuery.getItems().size(); ++i) {
            leftExprList.add(selectListOfInlineViewQuery.getItems().get(i).getExpr().clone());
            colAliasOfInlineView.add(inlineViewQuery.getColumnAliasGenerator().getNextAlias());
        }
        InlineViewRef inlineViewRef = new InlineViewRef(tableAliasGenerator.getNextAlias(), inlineViewQuery, colAliasOfInlineView);
        try {
            inlineViewRef.analyze(analyzer);
        }
        catch (UserException e) {
            throw new AnalysisException(e.getMessage());
        }
        LOG.debug("Outer query is changed to {}", (Object)inlineViewRef.tableRefToSql());
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        List<SelectListItem> inlineViewItems = inlineViewQuery.getSelectList().getItems();
        for (int i = 0; i < inlineViewItems.size(); ++i) {
            Expr leftExpr = (Expr)leftExprList.get(i);
            SlotRef rightExpr = new SlotRef(inlineViewRef.getAliasAsName(), (String)colAliasOfInlineView.get(i));
            rightExpr.analyze(analyzer);
            smap.put(leftExpr, rightExpr);
        }
        havingClause.reset();
        Expr newWherePredicate = havingClause.substitute(smap, analyzer, false);
        LOG.debug("Having predicate is changed to " + newWherePredicate.toSql());
        ArrayList newOrderByElements = null;
        if (orderByElements != null) {
            newOrderByElements = Lists.newArrayList();
            for (OrderByElement orderByElement : orderByElements) {
                OrderByElement newOrderByElement = new OrderByElement(orderByElement.getExpr().reset().substitute(smap), orderByElement.getIsAsc(), orderByElement.getNullsFirstParam());
                newOrderByElements.add(newOrderByElement);
                LOG.debug("Order by element is changed to " + newOrderByElement.toSql());
            }
        }
        ArrayList newSelectItems = Lists.newArrayList();
        for (int i = 0; i < selectList.getItems().size(); ++i) {
            SelectListItem newItem = new SelectListItem(selectList.getItems().get(i).getExpr().reset().substitute(smap), (String)columnLabels.get(i));
            newSelectItems.add(newItem);
            LOG.debug("New select item is changed to " + newItem.toSql());
        }
        SelectList newSelectList = new SelectList(newSelectItems, selectList.isDistinct());
        ArrayList newTableRefList = Lists.newArrayList();
        newTableRefList.add(inlineViewRef);
        FromClause newFromClause = new FromClause(newTableRefList);
        SelectStmt result = new SelectStmt(newSelectList, newFromClause, newWherePredicate, null, null, newOrderByElements, limitElement);
        result.setTableAliasGenerator(tableAliasGenerator);
        try {
            result.analyze(analyzer);
        }
        catch (UserException e) {
            throw new AnalysisException(e.getMessage());
        }
        LOG.info("New stmt {} is constructed after rewritten subquery of having clause.", (Object)result.toSql());
        result = StmtRewriter.rewriteSelectStatement(result, analyzer);
        LOG.debug("The final stmt is " + result.toSql());
        return result;
    }

    private static SelectList addMissingAggregationColumns(SelectList selectList, List<FunctionCallExpr> aggregateExprs) {
        SelectList result = selectList.clone();
        for (FunctionCallExpr functionCallExpr : aggregateExprs) {
            boolean columnExists = false;
            for (SelectListItem selectListItem : selectList.getItems()) {
                if (!selectListItem.getExpr().equals(functionCallExpr)) continue;
                columnExists = true;
                break;
            }
            if (columnExists) continue;
            SelectListItem selectListItem = new SelectListItem(functionCallExpr.clone().reset(), null);
            result.addItem(selectListItem);
        }
        return result;
    }

    private static void rewriteUnionStatement(SetOperationStmt stmt, Analyzer analyzer) throws AnalysisException {
        for (SetOperationStmt.SetOperand operand : stmt.getOperands()) {
            Preconditions.checkState((boolean)(operand.getQueryStmt() instanceof SelectStmt));
            SelectStmt rewrittenQueryStmt = StmtRewriter.rewriteSelectStatement((SelectStmt)operand.getQueryStmt(), operand.getAnalyzer());
            operand.setQueryStmt(rewrittenQueryStmt);
        }
    }

    private static boolean hasSubqueryInDisjunction(Expr expr) {
        if (!(expr instanceof CompoundPredicate)) {
            return false;
        }
        if (Expr.IS_OR_PREDICATE.apply((Object)expr)) {
            return expr.contains(Subquery.class);
        }
        for (Expr child : expr.getChildren()) {
            if (!StmtRewriter.hasSubqueryInDisjunction(child)) continue;
            return true;
        }
        return false;
    }

    private static void rewriteWhereClauseSubqueries(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
        int numTableRefs = stmt.fromClause_.size();
        ArrayList exprsWithSubqueries = Lists.newArrayList();
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        for (Expr conjunct : stmt.whereClause.getConjuncts()) {
            BoolLiteral boolLiteral;
            ArrayList subqueries = Lists.newArrayList();
            conjunct.collectAll(Predicates.instanceOf(Subquery.class), subqueries);
            if (subqueries.size() == 0) continue;
            if (subqueries.size() > 1) {
                throw new AnalysisException("Multiple subqueries are not supported in expression: " + conjunct.toSql());
            }
            if (!(conjunct instanceof InPredicate || conjunct instanceof ExistsPredicate || conjunct instanceof BinaryPredicate || conjunct.contains(Expr.IS_SCALAR_SUBQUERY))) {
                throw new AnalysisException("Non-scalar subquery is not supported in expression: " + conjunct.toSql());
            }
            if (conjunct instanceof ExistsPredicate && (boolLiteral = StmtRewriter.replaceExistsPredicate((ExistsPredicate)conjunct)) != null) {
                boolLiteral.analyze(analyzer);
                smap.put(conjunct, boolLiteral);
                continue;
            }
            boolLiteral = new BoolLiteral(true);
            boolLiteral.analyze(analyzer);
            smap.put(conjunct, boolLiteral);
            exprsWithSubqueries.add(conjunct);
        }
        stmt.whereClause = stmt.whereClause.substitute(smap, analyzer, false);
        boolean hasNewVisibleTuple = false;
        for (Expr expr : exprsWithSubqueries) {
            if (!StmtRewriter.mergeExpr(stmt, StmtRewriter.rewriteExpr(expr, analyzer), analyzer)) continue;
            hasNewVisibleTuple = true;
        }
        if (StmtRewriter.canEliminate(stmt.whereClause)) {
            stmt.whereClause = null;
        }
        if (hasNewVisibleTuple) {
            StmtRewriter.replaceUnqualifiedStarItems(stmt, numTableRefs);
        }
    }

    private static BoolLiteral replaceExistsPredicate(ExistsPredicate predicate) {
        Subquery subquery = predicate.getSubquery();
        Preconditions.checkNotNull((Object)subquery);
        SelectStmt subqueryStmt = (SelectStmt)subquery.getStatement();
        BoolLiteral boolLiteral = null;
        if (subqueryStmt.getAnalyzer().hasEmptyResultSet()) {
            boolLiteral = new BoolLiteral(predicate.isNotExists());
        } else if (subqueryStmt.hasAggInfo() && subqueryStmt.getAggInfo().hasAggregateExprs() && !subqueryStmt.hasAnalyticInfo() && subqueryStmt.getHavingPred() == null) {
            boolLiteral = new BoolLiteral(!predicate.isNotExists());
        }
        return boolLiteral;
    }

    private static boolean canEliminate(Expr expr) {
        for (Expr conjunct : expr.getConjuncts()) {
            if (Expr.IS_TRUE_LITERAL.apply((Object)conjunct)) continue;
            return false;
        }
        return true;
    }

    private static Expr rewriteExpr(Expr expr, Analyzer analyzer) throws AnalysisException {
        Subquery subquery = expr.getSubquery();
        Preconditions.checkNotNull((Object)subquery);
        QueryStmt rewrittenStmt = StmtRewriter.rewriteSelectStatement((SelectStmt)subquery.getStatement(), subquery.getAnalyzer());
        rewrittenStmt = rewrittenStmt.clone();
        rewrittenStmt.reset();
        Subquery newSubquery = new Subquery(rewrittenStmt);
        newSubquery.analyze(analyzer);
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        smap.put(subquery, newSubquery);
        return expr.substitute(smap, analyzer, false);
    }

    private static void canRewriteScalarFunction(Expr expr, Expr conjunct) throws AnalysisException {
        if (expr.getSubquery().isScalarSubquery()) {
            if (conjunct instanceof BinaryPredicate && ((BinaryPredicate)conjunct).getOp() == BinaryPredicate.Operator.EQ) {
                return;
            }
            throw new AnalysisException("scalar subquery's correlatedPredicates's operator must be EQ");
        }
    }

    private static boolean mergeExpr(SelectStmt stmt, Expr expr, Analyzer analyzer) throws AnalysisException {
        Expr onClausePredicate;
        LOG.debug("SUBQUERY mergeExpr stmt={} expr={}", (Object)stmt.toSql(), (Object)expr.toSql());
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkNotNull((Object)analyzer);
        Preconditions.checkState((expr.getSubquery().getAnalyzer() != null ? 1 : 0) != 0, (Object)("subquery must be analyze address=" + System.identityHashCode(expr.getSubquery())));
        boolean updateSelectList = false;
        SelectStmt subqueryStmt = (SelectStmt)expr.getSubquery().getStatement();
        ArrayList colLabels = Lists.newArrayList();
        for (int i = 0; i < ((ArrayList)subqueryStmt.getColLabels()).size(); ++i) {
            colLabels.add(subqueryStmt.getColumnAliasGenerator().getNextAlias());
        }
        InlineViewRef inlineView = new InlineViewRef(stmt.getTableAliasGenerator().getNextAlias(), subqueryStmt, colLabels);
        ArrayList<Expr> onClauseConjuncts = StmtRewriter.extractCorrelatedPredicates(subqueryStmt);
        if (!onClauseConjuncts.isEmpty()) {
            StmtRewriter.canRewriteCorrelatedSubquery(expr, onClauseConjuncts);
            subqueryStmt.limitElement = new LimitElement();
        }
        boolean updateGroupBy = expr.getSubquery().isScalarSubquery() || expr instanceof ExistsPredicate && subqueryStmt.hasAggInfo();
        ArrayList lhsExprs = Lists.newArrayList();
        ArrayList rhsExprs = Lists.newArrayList();
        for (Expr conjunct : onClauseConjuncts) {
            StmtRewriter.canRewriteScalarFunction(expr, conjunct);
            StmtRewriter.updateInlineView(inlineView, conjunct, stmt.getTableRefIds(), lhsExprs, rhsExprs, updateGroupBy);
        }
        if (expr instanceof ExistsPredicate && onClauseConjuncts.isEmpty()) {
            subqueryStmt.setLimit(1L);
        }
        inlineView.reset();
        try {
            inlineView.analyze(analyzer);
        }
        catch (UserException e) {
            throw new AnalysisException(e.getMessage());
        }
        inlineView.setLeftTblRef(stmt.fromClause_.get(stmt.fromClause_.size() - 1));
        stmt.fromClause_.add(inlineView);
        JoinOperator joinOp = JoinOperator.LEFT_SEMI_JOIN;
        Expr joinConjunct = StmtRewriter.createJoinConjunct(expr, inlineView, analyzer, !onClauseConjuncts.isEmpty());
        if (joinConjunct != null) {
            SelectListItem firstItem = ((SelectStmt)inlineView.getViewStmt()).getSelectList().getItems().get(0);
            if (!onClauseConjuncts.isEmpty() && firstItem.getExpr().contains(Expr.NON_NULL_EMPTY_AGG)) {
                stmt.whereClause = CompoundPredicate.createConjunction(joinConjunct, stmt.whereClause);
                joinConjunct = null;
                joinOp = JoinOperator.LEFT_OUTER_JOIN;
                updateSelectList = true;
            }
            if (joinConjunct != null) {
                onClauseConjuncts.add(joinConjunct);
            }
        }
        if ((onClausePredicate = CompoundPredicate.createConjunctivePredicate(onClauseConjuncts)) == null) {
            Preconditions.checkState((boolean)(expr instanceof ExistsPredicate));
            if (((ExistsPredicate)expr).isNotExists()) {
                throw new AnalysisException("Unsupported uncorrelated NOT EXISTS subquery: " + subqueryStmt.toSql());
            }
            inlineView.setJoinOp(JoinOperator.CROSS_JOIN);
            LOG.warn("uncorrelated subquery rewritten using a cross join");
            return true;
        }
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        Preconditions.checkState((lhsExprs.size() == rhsExprs.size() ? 1 : 0) != 0);
        for (int i = 0; i < lhsExprs.size(); ++i) {
            Expr lhsExpr = (Expr)lhsExprs.get(i);
            Expr rhsExpr = (Expr)rhsExprs.get(i);
            rhsExpr.analyze(analyzer);
            smap.put(lhsExpr, rhsExpr);
        }
        if (!(onClausePredicate = onClausePredicate.substitute(smap, analyzer, false)).isBoundByTupleIds(stmt.getTableRefIds())) {
            throw new AnalysisException("Unsupported correlated subquery: " + subqueryStmt.toSql());
        }
        boolean hasEqJoinPred = false;
        for (Expr conjunct : onClausePredicate.getConjuncts()) {
            BinaryPredicate.Operator operator;
            if (!(conjunct instanceof BinaryPredicate) || !(operator = ((BinaryPredicate)conjunct).getOp()).isEquivalence()) continue;
            ArrayList lhsTupleIds = Lists.newArrayList();
            ((Expr)conjunct.getChild(0)).getIds(lhsTupleIds, null);
            if (lhsTupleIds.isEmpty()) continue;
            ArrayList rhsTupleIds = Lists.newArrayList();
            ((Expr)conjunct.getChild(1)).getIds(rhsTupleIds, null);
            if (rhsTupleIds.isEmpty() || lhsTupleIds.contains(inlineView.getDesc().getId()) && lhsTupleIds.size() > 1 || rhsTupleIds.contains(inlineView.getDesc().getId()) && rhsTupleIds.size() > 1) continue;
            hasEqJoinPred = true;
            break;
        }
        if (!hasEqJoinPred && !inlineView.isCorrelated()) {
            boolean hasGroupBy = ((SelectStmt)inlineView.getViewStmt()).hasGroupByClause();
            if (!expr.getSubquery().returnsScalarColumn()) {
                throw new AnalysisException("Unsupported predicate with subquery: " + expr.toSql());
            }
            if (expr.getSubquery().isScalarSubquery() && expr instanceof InPredicate && ((InPredicate)expr).isNotIn()) {
                throw new AnalysisException("Unsupported NOT IN predicate with subquery: " + expr.toSql());
            }
            stmt.whereClause = CompoundPredicate.createConjunction(onClausePredicate, stmt.whereClause);
            inlineView.setJoinOp(JoinOperator.CROSS_JOIN);
            return true;
        }
        if (expr instanceof InPredicate && ((InPredicate)expr).isNotIn() || expr instanceof ExistsPredicate && ((ExistsPredicate)expr).isNotExists()) {
            if (expr instanceof InPredicate) {
                joinOp = JoinOperator.LEFT_ANTI_JOIN;
                ArrayList tIds = Lists.newArrayList();
                joinConjunct.getIds(tIds, null);
                if (tIds.size() <= 1 || !tIds.contains(inlineView.getDesc().getId())) {
                    throw new AnalysisException("Unsupported NOT IN predicate with subquery: " + expr.toSql());
                }
                for (Expr conjunct : onClausePredicate.getConjuncts()) {
                    if (!conjunct.equals(joinConjunct)) continue;
                    Preconditions.checkState((boolean)(conjunct instanceof BinaryPredicate));
                    Preconditions.checkState((((BinaryPredicate)conjunct).getOp() == BinaryPredicate.Operator.EQ ? 1 : 0) != 0);
                    break;
                }
            } else {
                joinOp = JoinOperator.LEFT_ANTI_JOIN;
            }
        }
        inlineView.setJoinOp(joinOp);
        inlineView.setOnClause(onClausePredicate);
        return updateSelectList;
    }

    private static void replaceUnqualifiedStarItems(SelectStmt stmt, int tableIdx) {
        Preconditions.checkState((tableIdx < stmt.fromClause_.size() ? 1 : 0) != 0);
        ArrayList newItems = Lists.newArrayList();
        for (int i = 0; i < stmt.selectList.getItems().size(); ++i) {
            SelectListItem item = stmt.selectList.getItems().get(i);
            if (!item.isStar() || item.getTblName() != null) {
                newItems.add(item);
                continue;
            }
            for (int j = 0; j < tableIdx; ++j) {
                TableRef tableRef = stmt.fromClause_.get(j);
                if (tableRef.getJoinOp() == JoinOperator.LEFT_SEMI_JOIN || tableRef.getJoinOp() == JoinOperator.LEFT_ANTI_JOIN) continue;
                newItems.add(SelectListItem.createStarItem(tableRef.getAliasAsName()));
            }
        }
        Preconditions.checkState((!newItems.isEmpty() ? 1 : 0) != 0);
        boolean isDistinct = stmt.selectList.isDistinct();
        stmt.selectList = new SelectList(newItems, isDistinct);
    }

    private static boolean containsCorrelatedPredicate(Expr root, List<TupleId> tupleIds) {
        if (StmtRewriter.isCorrelatedPredicate(root, tupleIds)) {
            return true;
        }
        for (Expr child : root.getChildren()) {
            if (!StmtRewriter.containsCorrelatedPredicate(child, tupleIds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCorrelatedPredicate(Expr expr, List<TupleId> tupleIds) {
        return (expr instanceof BinaryPredicate || expr instanceof SlotRef) && !expr.isBoundByTupleIds(tupleIds);
    }

    private static ArrayList<Expr> extractCorrelatedPredicates(SelectStmt subqueryStmt) throws AnalysisException {
        List<TupleId> subqueryTupleIds = subqueryStmt.getTableRefIds();
        ArrayList correlatedPredicates = Lists.newArrayList();
        if (subqueryStmt.hasWhereClause()) {
            if (!StmtRewriter.canExtractCorrelatedPredicates(subqueryStmt.getWhereClause(), subqueryTupleIds)) {
                throw new AnalysisException("Disjunctions with correlated predicates are not supported: " + subqueryStmt.getWhereClause().toSql());
            }
            Expr newWhereClause = StmtRewriter.extractCorrelatedPredicates(subqueryStmt.getWhereClause(), subqueryTupleIds, correlatedPredicates);
            if (StmtRewriter.canEliminate(newWhereClause)) {
                newWhereClause = null;
            }
            subqueryStmt.setWhereClause(newWhereClause);
        }
        for (TableRef tableRef : subqueryStmt.getTableRefs()) {
            if (tableRef.getOnClause() == null) continue;
            ArrayList onClauseCorrelatedPreds = Lists.newArrayList();
            Expr newOnClause = StmtRewriter.extractCorrelatedPredicates(tableRef.getOnClause(), subqueryTupleIds, onClauseCorrelatedPreds);
            if (onClauseCorrelatedPreds.isEmpty()) continue;
            correlatedPredicates.addAll(onClauseCorrelatedPreds);
            if (StmtRewriter.canEliminate(newOnClause)) {
                tableRef.setJoinOp(JoinOperator.CROSS_JOIN);
                tableRef.setOnClause(null);
                continue;
            }
            tableRef.setOnClause(newOnClause);
        }
        return correlatedPredicates;
    }

    private static Expr extractCorrelatedPredicates(Expr root, List<TupleId> tupleIds, ArrayList<Expr> matches) {
        if (StmtRewriter.isCorrelatedPredicate(root, tupleIds)) {
            matches.add(root);
            return new BoolLiteral(true);
        }
        for (int i = 0; i < root.getChildren().size(); ++i) {
            root.getChildren().set(i, StmtRewriter.extractCorrelatedPredicates((Expr)root.getChild(i), tupleIds, matches));
        }
        return root;
    }

    private static boolean canExtractCorrelatedPredicates(Expr expr, List<TupleId> subqueryTupleIds) {
        if (!(expr instanceof CompoundPredicate)) {
            return true;
        }
        if (Expr.IS_OR_PREDICATE.apply((Object)expr)) {
            return !StmtRewriter.containsCorrelatedPredicate(expr, subqueryTupleIds);
        }
        for (Expr child : expr.getChildren()) {
            if (StmtRewriter.canExtractCorrelatedPredicates(child, subqueryTupleIds)) continue;
            return false;
        }
        return true;
    }

    private static void canRewriteCorrelatedSubquery(Expr expr, List<Expr> correlatedPredicates) throws AnalysisException {
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)expr.contains(Subquery.class));
        SelectStmt stmt = (SelectStmt)expr.getSubquery().getStatement();
        Preconditions.checkNotNull((Object)stmt);
        if (expr instanceof BinaryPredicate) {
            if (stmt.getSelectList().getItems().size() != 1) {
                throw new AnalysisException("The subquery only support one item in select clause");
            }
            SelectListItem item = stmt.getSelectList().getItems().get(0);
            if (!item.getExpr().contains(Expr.CORRELATED_SUBQUERY_SUPPORT_AGG_FN)) {
                throw new AnalysisException("The select item in correlated subquery of binary predicate should only be sum, min, max, avg and count. Current subquery:" + stmt.toSql());
            }
        }
        if (expr instanceof InPredicate && (stmt.hasAggInfo() || stmt.hasAnalyticInfo())) {
            LOG.warn("canRewriteCorrelatedSubquery fail, expr={} subquery={}", (Object)expr.toSql(), (Object)stmt.toSql());
            throw new AnalysisException("Unsupported correlated subquery with grouping and/or aggregation: " + stmt.toSql());
        }
        Predicate<Expr> isSingleSlotRef = new Predicate<Expr>(){

            public boolean apply(Expr arg) {
                return arg.unwrapSlotRef(false) != null;
            }
        };
        if (!(!(expr instanceof ExistsPredicate) || !stmt.hasHavingClause() || correlatedPredicates.isEmpty() || stmt.hasAggInfo() && Iterables.all(correlatedPredicates, (Predicate)Predicates.or(Expr.IS_EQ_BINARY_PREDICATE, (Predicate)isSingleSlotRef)))) {
            throw new AnalysisException("Unsupported correlated EXISTS subquery with a HAVING clause: " + stmt.toSql());
        }
        if (!(!stmt.hasLimitClause() || expr instanceof BinaryPredicate && stmt.hasAggInfo() && !stmt.selectList.isDistinct() || expr instanceof ExistsPredicate)) {
            throw new AnalysisException("Unsupported correlated subquery with a LIMIT clause: " + stmt.toSql());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateInlineView(InlineViewRef inlineView, Expr expr, List<TupleId> parentQueryTids, List<Expr> lhsExprs, List<Expr> rhsExprs, boolean updateGroupBy) throws AnalysisException {
        SelectStmt stmt = (SelectStmt)inlineView.getViewStmt();
        List<TupleId> subqueryTblIds = stmt.getTableRefIds();
        ArrayList groupByExprs = null;
        if (updateGroupBy) {
            groupByExprs = Lists.newArrayList();
        }
        List<SelectListItem> items = stmt.selectList.getItems();
        ArrayList slotRefs = Lists.newArrayList();
        expr.collectAll(Predicates.instanceOf(SlotRef.class), slotRefs);
        ArrayList exprsBoundBySubqueryTids = Lists.newArrayList();
        for (Expr slotRef : slotRefs) {
            if (!slotRef.isBoundByTupleIds(subqueryTblIds)) continue;
            exprsBoundBySubqueryTids.add(slotRef);
        }
        if (exprsBoundBySubqueryTids.isEmpty()) {
            return;
        }
        if (updateGroupBy) {
            Preconditions.checkState((boolean)(expr instanceof BinaryPredicate));
            Object exprBoundBySubqueryTids = null;
            if (exprsBoundBySubqueryTids.size() > 1) {
                if (((Expr)expr.getChild(0)).isBoundByTupleIds(subqueryTblIds) && ((Expr)expr.getChild(1)).isBoundByTupleIds(parentQueryTids)) {
                    exprBoundBySubqueryTids = (Expr)expr.getChild(0);
                } else {
                    if (!((Expr)expr.getChild(0)).isBoundByTupleIds(parentQueryTids) || !((Expr)expr.getChild(1)).isBoundByTupleIds(subqueryTblIds)) throw new AnalysisException("All subquery columns that participate in a predicate must be on the same side of that predicate: " + expr.toSql());
                    exprBoundBySubqueryTids = (Expr)expr.getChild(1);
                }
            } else {
                Preconditions.checkState((exprsBoundBySubqueryTids.size() == 1 ? 1 : 0) != 0);
                exprBoundBySubqueryTids = (Expr)exprsBoundBySubqueryTids.get(0);
            }
            exprsBoundBySubqueryTids.clear();
            exprsBoundBySubqueryTids.add(exprBoundBySubqueryTids);
        }
        for (Expr boundExpr : exprsBoundBySubqueryTids) {
            String colAlias = stmt.getColumnAliasGenerator().getNextAlias();
            items.add(new SelectListItem(boundExpr, null));
            inlineView.getExplicitColLabels().add(colAlias);
            lhsExprs.add(boundExpr);
            rhsExprs.add(new SlotRef(inlineView.getAliasAsName(), colAlias));
            if (groupByExprs == null) continue;
            groupByExprs.add(boundExpr);
        }
        boolean isDistinct = stmt.selectList.isDistinct();
        Preconditions.checkState((!isDistinct ? 1 : 0) != 0);
        stmt.selectList = new SelectList(items, isDistinct);
        if (groupByExprs == null || groupByExprs.isEmpty()) return;
        if (stmt.hasGroupByClause()) {
            stmt.groupByClause.getGroupingExprs().addAll(groupByExprs);
            stmt.groupByClause.getOriGroupingExprs().addAll(groupByExprs);
            return;
        } else {
            stmt.groupByClause = new GroupByClause(groupByExprs, GroupByClause.GroupingType.GROUP_BY);
        }
    }

    private static Expr createJoinConjunct(Expr exprWithSubquery, InlineViewRef inlineView, Analyzer analyzer, boolean isCorrelated) throws AnalysisException {
        Preconditions.checkNotNull((Object)exprWithSubquery);
        Preconditions.checkNotNull((Object)inlineView);
        Preconditions.checkState((boolean)exprWithSubquery.contains(Subquery.class));
        if (exprWithSubquery instanceof ExistsPredicate) {
            return null;
        }
        SlotRef slotRef = new SlotRef(new TableName(null, inlineView.getAlias()), inlineView.getColLabels().get(0));
        slotRef.analyze(analyzer);
        Expr subquerySubstitute = slotRef;
        if (exprWithSubquery instanceof InPredicate) {
            BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.EQ, (Expr)exprWithSubquery.getChild(0), slotRef);
            pred.analyze(analyzer);
            return pred;
        }
        Subquery subquery = exprWithSubquery.getSubquery();
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        SelectListItem item = ((SelectStmt)inlineView.getViewStmt()).getSelectList().getItems().get(0);
        if (isCorrelated && item.getExpr().contains(Expr.NON_NULL_EMPTY_AGG)) {
            if (!(Expr.NON_NULL_EMPTY_AGG.apply((Object)item.getExpr()) || item.getExpr() instanceof CastExpr && Expr.NON_NULL_EMPTY_AGG.apply((Object)((Expr)item.getExpr().getChild(0))))) {
                throw new AnalysisException("Aggregate function that returns non-null on an empty input cannot be used in an expression in a correlated subquery's select list: " + subquery.toSql());
            }
            ArrayList aggFns = Lists.newArrayList();
            item.getExpr().collectAll(Expr.NON_NULL_EMPTY_AGG, aggFns);
            if (((FunctionCallExpr)aggFns.get(0)).getFn().getReturnType().isNumericType()) {
                FunctionCallExpr zeroIfNull = new FunctionCallExpr("ifnull", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{slotRef, new IntLiteral(0L, (Type)Type.BIGINT)}));
                zeroIfNull.analyze(analyzer);
                subquerySubstitute = zeroIfNull;
            } else if (((FunctionCallExpr)aggFns.get(0)).getFn().getReturnType().isStringType()) {
                ArrayList params = Lists.newArrayList();
                params.add(slotRef);
                params.add(new StringLiteral(""));
                FunctionCallExpr ifnull = new FunctionCallExpr("ifnull", (List<Expr>)params);
                ifnull.analyze(analyzer);
                subquerySubstitute = ifnull;
            } else {
                throw new AnalysisException("Unsupported aggregate function used in a correlated subquery's select list: " + subquery.toSql());
            }
        }
        smap.put(subquery, subquerySubstitute);
        return exprWithSubquery.substitute(smap, analyzer, false);
    }
}

