/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ExplainOptions;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.rewrite.ExprRewriter;

public abstract class StatementBase
implements ParseNode {
    private String clusterName;
    protected ExplainOptions explainOptions = null;
    protected Analyzer analyzer;
    private OriginStatement origStmt;
    private UserIdentity userInfo;

    protected StatementBase() {
    }

    protected StatementBase(StatementBase other) {
        this.analyzer = other.analyzer;
        this.explainOptions = other.explainOptions;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (this.isAnalyzed()) {
            return;
        }
        this.analyzer = analyzer;
        if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_SELECT_CLUSTER, new Object[0]);
        }
        this.clusterName = analyzer.getClusterName();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean isAnalyzed() {
        return this.analyzer != null;
    }

    public void setIsExplain(ExplainOptions options) {
        this.explainOptions = options;
    }

    public boolean isExplain() {
        return this.explainOptions != null;
    }

    public boolean isVerbose() {
        return this.explainOptions != null && this.explainOptions.isVerbose();
    }

    public ExplainOptions getExplainOptions() {
        return this.explainOptions;
    }

    @Override
    public String toSql() {
        return "";
    }

    public abstract RedirectStatus getRedirectStatus();

    public List<String> getColLabels() {
        return Collections.emptyList();
    }

    public void setColLabels(List<String> colLabels) {
        List<String> oldLabels = this.getColLabels();
        if (oldLabels == colLabels) {
            return;
        }
        oldLabels.clear();
        oldLabels.addAll(colLabels);
    }

    public List<Expr> getResultExprs() {
        return Collections.emptyList();
    }

    public void castResultExprs(List<Type> types) throws AnalysisException {
        List<Expr> resultExprs = this.getResultExprs();
        Preconditions.checkNotNull(resultExprs);
        Preconditions.checkState((resultExprs.size() == types.size() ? 1 : 0) != 0);
        for (int i = 0; i < types.size(); ++i) {
            if (resultExprs.get(i).getType().isDateType() && types.get(i).isDateType() || resultExprs.get(i).getType().equals(types.get(i))) continue;
            resultExprs.set(i, resultExprs.get(i).castTo(types.get(i)));
        }
    }

    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        throw new IllegalStateException("rewriteExprs() not implemented for this stmt: " + this.getClass().getSimpleName());
    }

    public void foldConstant(ExprRewriter rewriter) throws AnalysisException {
        throw new IllegalStateException("foldConstant() not implemented for this stmt: " + this.getClass().getSimpleName());
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setOrigStmt(OriginStatement origStmt) {
        Preconditions.checkState((origStmt != null ? 1 : 0) != 0);
        this.origStmt = origStmt;
    }

    public OriginStatement getOrigStmt() {
        return this.origStmt;
    }

    public UserIdentity getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserIdentity userInfo) {
        this.userInfo = userInfo;
    }

    public void reset() {
        this.analyzer = null;
    }

    public boolean needAuditEncryption() {
        return false;
    }
}

