/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.common.TreeNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SortInfo {
    private static final Logger LOG = LogManager.getLogger(SortInfo.class);
    private static final float SORT_MATERIALIZATION_COST_THRESHOLD = 10.0f;
    private List<Expr> orderingExprs_;
    private final List<Boolean> isAscOrder_;
    private final List<Boolean> nullsFirstParams_;
    private List<Expr> materializedOrderingExprs_;
    private TupleDescriptor sortTupleDesc_;
    private List<Expr> sortTupleSlotExprs_;

    public SortInfo(List<Expr> orderingExprs, List<Boolean> isAscOrder, List<Boolean> nullsFirstParams) {
        Preconditions.checkArgument((orderingExprs.size() == isAscOrder.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((orderingExprs.size() == nullsFirstParams.size() ? 1 : 0) != 0);
        this.orderingExprs_ = orderingExprs;
        this.isAscOrder_ = isAscOrder;
        this.nullsFirstParams_ = nullsFirstParams;
        this.materializedOrderingExprs_ = Lists.newArrayList();
    }

    private SortInfo(SortInfo other) {
        this.orderingExprs_ = Expr.cloneList(other.orderingExprs_);
        this.isAscOrder_ = Lists.newArrayList(other.isAscOrder_);
        this.nullsFirstParams_ = Lists.newArrayList(other.nullsFirstParams_);
        this.materializedOrderingExprs_ = Expr.cloneList(other.materializedOrderingExprs_);
        this.sortTupleDesc_ = other.sortTupleDesc_;
        if (other.sortTupleSlotExprs_ != null) {
            this.sortTupleSlotExprs_ = Expr.cloneList(other.sortTupleSlotExprs_);
        }
    }

    public void setMaterializedTupleInfo(TupleDescriptor tupleDesc, List<Expr> tupleSlotExprs) {
        Preconditions.checkState((tupleDesc.getSlots().size() == tupleSlotExprs.size() ? 1 : 0) != 0);
        this.sortTupleDesc_ = tupleDesc;
        this.sortTupleSlotExprs_ = tupleSlotExprs;
        for (int i = 0; i < this.sortTupleDesc_.getSlots().size(); ++i) {
            SlotDescriptor slotDesc = this.sortTupleDesc_.getSlots().get(i);
            slotDesc.setSourceExpr(this.sortTupleSlotExprs_.get(i));
        }
    }

    public List<Expr> getOrderingExprs() {
        return this.orderingExprs_;
    }

    public List<Boolean> getIsAscOrder() {
        return this.isAscOrder_;
    }

    public List<Boolean> getNullsFirstParams() {
        return this.nullsFirstParams_;
    }

    public List<Expr> getMaterializedOrderingExprs() {
        return this.materializedOrderingExprs_;
    }

    public List<Expr> getSortTupleSlotExprs() {
        return this.sortTupleSlotExprs_;
    }

    public TupleDescriptor getSortTupleDescriptor() {
        return this.sortTupleDesc_;
    }

    public List<Boolean> getNullsFirst() {
        Preconditions.checkState((this.orderingExprs_.size() == this.nullsFirstParams_.size() ? 1 : 0) != 0);
        ArrayList nullsFirst = Lists.newArrayList();
        for (int i = 0; i < this.orderingExprs_.size(); ++i) {
            nullsFirst.add(OrderByElement.nullsFirst(this.nullsFirstParams_.get(i), this.isAscOrder_.get(i)));
        }
        return nullsFirst;
    }

    public void materializeRequiredSlots(Analyzer analyzer, ExprSubstitutionMap smap) {
        Preconditions.checkNotNull((Object)this.sortTupleDesc_);
        Preconditions.checkNotNull(this.sortTupleSlotExprs_);
        Preconditions.checkState((boolean)this.sortTupleDesc_.isMaterialized());
        analyzer.materializeSlots(this.orderingExprs_);
        ArrayList<SlotDescriptor> sortTupleSlotDescs = this.sortTupleDesc_.getSlots();
        ArrayList materializedExprs = Lists.newArrayList();
        for (int i = 0; i < sortTupleSlotDescs.size(); ++i) {
            if (!((SlotDescriptor)sortTupleSlotDescs.get(i)).isMaterialized()) continue;
            materializedExprs.add(this.sortTupleSlotExprs_.get(i));
        }
        ArrayList<Expr> substMaterializedExprs = Expr.substituteList(materializedExprs, smap, analyzer, false);
        analyzer.materializeSlots(substMaterializedExprs);
    }

    public void substituteOrderingExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.orderingExprs_ = Expr.substituteList(this.orderingExprs_, smap, analyzer, false);
    }

    public void checkConsistency() {
        for (Expr orderingExpr : this.orderingExprs_) {
            Preconditions.checkState((boolean)orderingExpr.isBound(this.sortTupleDesc_.getId()));
        }
    }

    public SortInfo clone() {
        return new SortInfo(this);
    }

    public ExprSubstitutionMap createSortTupleInfo(List<Expr> resultExprs, Analyzer analyzer) {
        TupleDescriptor sortTupleDesc = analyzer.getDescTbl().createTupleDescriptor("sort");
        sortTupleDesc.setIsMaterialized(true);
        ArrayList sortTupleExprs = Lists.newArrayList();
        ExprSubstitutionMap substOrderBy = this.createMaterializedOrderExprs(sortTupleDesc, analyzer);
        sortTupleExprs.addAll(substOrderBy.getLhs());
        HashSet sourceSlots = Sets.newHashSet();
        TreeNode.collect(Expr.substituteList(resultExprs, substOrderBy, analyzer, false), Predicates.instanceOf(SlotRef.class), sourceSlots);
        TreeNode.collect(Expr.substituteList(this.orderingExprs_, substOrderBy, analyzer, false), Predicates.instanceOf(SlotRef.class), sourceSlots);
        for (SlotRef origSlotRef : sourceSlots) {
            if (origSlotRef.getDesc().getParent().getId() == sortTupleDesc.getId()) continue;
            SlotDescriptor origSlotDesc = origSlotRef.getDesc();
            SlotDescriptor materializedDesc = analyzer.copySlotDescriptor(origSlotDesc, sortTupleDesc);
            SlotRef cloneRef = new SlotRef(materializedDesc);
            substOrderBy.put(origSlotRef, cloneRef);
            sortTupleExprs.add(origSlotRef);
        }
        this.substituteOrderingExprs(substOrderBy, analyzer);
        this.setMaterializedTupleInfo(sortTupleDesc, sortTupleExprs);
        return substOrderBy;
    }

    public ExprSubstitutionMap createMaterializedOrderExprs(TupleDescriptor sortTupleDesc, Analyzer analyzer) {
        ExprSubstitutionMap substOrderBy = new ExprSubstitutionMap();
        for (Expr origOrderingExpr : this.orderingExprs_) {
            SlotDescriptor materializedDesc = analyzer.addSlotDescriptor(sortTupleDesc);
            materializedDesc.initFromExpr(origOrderingExpr);
            materializedDesc.setIsMaterialized(true);
            SlotRef materializedRef = new SlotRef(materializedDesc);
            substOrderBy.put(origOrderingExpr, materializedRef);
            this.materializedOrderingExprs_.add(origOrderingExpr);
        }
        return substOrderBy;
    }
}

