/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.util.ToSqlContext;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TSlotRef;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlotRef
extends Expr {
    private static final Logger LOG = LogManager.getLogger(SlotRef.class);
    private TableName tblName;
    private String col;
    private String label;
    protected SlotDescriptor desc;

    private SlotRef() {
    }

    public SlotRef(TableName tblName, String col) {
        this.tblName = tblName;
        this.col = col;
        this.label = "`" + col + "`";
    }

    public SlotRef(SlotDescriptor desc) {
        this.tblName = null;
        this.col = null;
        this.desc = desc;
        this.type = desc.getType();
        this.label = null;
        if (this.type.equals(Type.CHAR)) {
            this.type = Type.VARCHAR;
        }
        this.analysisDone();
    }

    protected SlotRef(SlotRef other) {
        super(other);
        this.tblName = other.tblName;
        this.col = other.col;
        this.label = other.label;
        this.desc = other.desc;
    }

    @Override
    public Expr clone() {
        return new SlotRef(this);
    }

    public SlotDescriptor getDesc() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkNotNull((Object)this.desc);
        return this.desc;
    }

    public SlotId getSlotId() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkNotNull((Object)this.desc);
        return this.desc.getId();
    }

    public Column getColumn() {
        if (this.desc == null) {
            return null;
        }
        return this.desc.getColumn();
    }

    public void setTblName(TableName name) {
        this.tblName = name;
    }

    public void setDesc(SlotDescriptor desc) {
        this.desc = desc;
    }

    public boolean columnEqual(Expr srcExpr) {
        String thisColumnName;
        TableName thisTableName;
        Preconditions.checkState((boolean)(srcExpr instanceof SlotRef));
        SlotRef srcSlotRef = (SlotRef)srcExpr;
        if (this.desc != null && srcSlotRef.desc != null) {
            return this.desc.getId().equals(srcSlotRef.desc.getId());
        }
        TableName srcTableName = srcSlotRef.tblName;
        if (srcTableName == null && srcSlotRef.desc != null) {
            srcTableName = srcSlotRef.getTableName();
        }
        if ((thisTableName = this.tblName) == null && this.desc != null) {
            thisTableName = this.getTableName();
        }
        if (thisTableName == null != (srcTableName == null)) {
            return false;
        }
        if (thisTableName != null && !thisTableName.equals(srcTableName)) {
            return false;
        }
        String srcColumnName = srcSlotRef.getColumnName();
        if (srcColumnName == null && srcSlotRef.desc != null && srcSlotRef.getDesc().getColumn() != null) {
            srcColumnName = srcSlotRef.desc.getColumn().getName();
        }
        if ((thisColumnName = this.getColumnName()) == null && this.desc != null && this.desc.getColumn() != null) {
            thisColumnName = this.desc.getColumn().getName();
        }
        if (thisColumnName == null != (srcColumnName == null)) {
            return false;
        }
        return thisColumnName == null || thisColumnName.toLowerCase().equals(srcColumnName.toLowerCase());
    }

    @Override
    public void vectorizedAnalyze(Analyzer analyzer) {
        this.computeOutputColumn(analyzer);
    }

    @Override
    public void computeOutputColumn(Analyzer analyzer) {
        this.outputColumn = this.desc.getSlotOffset();
        LOG.debug("SlotRef: " + this.debugString() + " outputColumn: " + this.outputColumn);
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.desc = analyzer.registerColumnRef(this.tblName, this.col);
        this.type = this.desc.getType();
        if (this.type.equals(Type.CHAR)) {
            this.type = Type.VARCHAR;
        }
        if (!this.type.isSupported()) {
            throw new AnalysisException("Unsupported type '" + this.type.toString() + "' in '" + this.toSql() + "'.");
        }
        this.numDistinctValues = this.desc.getStats().getNumDistinctValues();
        if (this.type.equals(Type.BOOLEAN)) {
            this.selectivity = 0.1;
        }
    }

    @Override
    public String debugString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("slotDesc", (Object)(this.desc != null ? this.desc.debugString() : "null"));
        helper.add("col", (Object)this.col);
        helper.add("label", (Object)this.label);
        helper.add("tblName", (Object)(this.tblName != null ? this.tblName.toSql() : "null"));
        return helper.toString();
    }

    @Override
    public String toSqlImpl() {
        StringBuilder sb = new StringBuilder();
        if (this.tblName != null) {
            return this.tblName.toSql() + "." + this.label + sb.toString();
        }
        if (this.label != null) {
            return this.label + sb.toString();
        }
        if (this.desc.getSourceExprs() != null) {
            if ((ToSqlContext.get() == null || ToSqlContext.get().isNeedSlotRefId()) && this.desc.getId().asInt() != 1) {
                sb.append("<slot " + this.desc.getId().asInt() + ">");
            }
            for (Expr expr : this.desc.getSourceExprs()) {
                sb.append(" ");
                sb.append(expr.toSql());
            }
            return sb.toString();
        }
        return "<slot " + this.desc.getId().asInt() + ">" + sb.toString();
    }

    @Override
    public String toMySql() {
        if (this.col != null) {
            return this.col;
        }
        return "<slot " + Integer.toString(this.desc.getId().asInt()) + ">";
    }

    public TableName getTableName() {
        Preconditions.checkState((boolean)this.isAnalyzed);
        Preconditions.checkNotNull((Object)this.desc);
        if (this.tblName == null) {
            Preconditions.checkNotNull((Object)this.desc.getParent());
            if (this.desc.getParent().getRef() == null) {
                return null;
            }
            return this.desc.getParent().getRef().getName();
        }
        return this.tblName;
    }

    public TableName getOriginTableName() {
        return this.tblName;
    }

    @Override
    public String toColumnLabel() {
        return this.col;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.SLOT_REF;
        msg.slot_ref = new TSlotRef(this.desc.getId().asInt(), this.desc.getParent().getId().asInt());
        msg.setOutputColumn(this.outputColumn);
    }

    @Override
    public void markAgg() {
        this.desc.setIsAgg(true);
    }

    @Override
    public int hashCode() {
        if (this.desc != null) {
            return this.desc.getId().hashCode();
        }
        return Objects.hashCode((Object[])new Object[]{(this.tblName == null ? "" : this.tblName.toSql() + "." + this.label).toLowerCase()});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SlotRef other = (SlotRef)obj;
        if (this.desc != null && other.desc != null) {
            return this.desc.getId().equals(other.desc.getId());
        }
        return this.notCheckDescIdEquals(obj);
    }

    public boolean notCheckDescIdEquals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SlotRef other = (SlotRef)obj;
        if (this.tblName == null != (other.tblName == null)) {
            return false;
        }
        if (this.tblName != null && !this.tblName.equals(other.tblName)) {
            return false;
        }
        if (this.col == null != (other.col == null)) {
            return false;
        }
        return this.col == null || this.col.equalsIgnoreCase(other.col);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        for (TupleId tid : tids) {
            if (!tid.equals(this.desc.getParent().getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(SlotId slotId) {
        Preconditions.checkState((boolean)this.isAnalyzed);
        return this.desc.getId().equals(slotId);
    }

    @Override
    public void getSlotRefsBoundByTupleIds(List<TupleId> tupleIds, Set<SlotRef> boundSlotRefs) {
        if (this.desc == null) {
            return;
        }
        if (tupleIds.contains(this.desc.getParent().getId())) {
            boundSlotRefs.add(this);
            return;
        }
        if (this.desc.getSourceExprs() == null) {
            return;
        }
        for (Expr sourceExpr : this.desc.getSourceExprs()) {
            sourceExpr.getSlotRefsBoundByTupleIds(tupleIds, boundSlotRefs);
        }
    }

    @Override
    public void getIds(List<TupleId> tupleIds, List<SlotId> slotIds) {
        Preconditions.checkState((!this.type.equals(Type.INVALID) ? 1 : 0) != 0);
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        if (slotIds != null) {
            slotIds.add(this.desc.getId());
        }
        if (tupleIds != null) {
            tupleIds.add(this.desc.getParent().getId());
        }
    }

    @Override
    public void getTableIdToColumnNames(Map<Long, Set<String>> tableIdToColumnNames) {
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        if (!this.desc.isMaterialized()) {
            return;
        }
        if (this.col == null) {
            for (Expr expr : this.desc.getSourceExprs()) {
                expr.getTableIdToColumnNames(tableIdToColumnNames);
            }
        } else {
            Table table = this.desc.getParent().getTable();
            if (table == null) {
                return;
            }
            Long tableId = table.getId();
            Set<String> columnNames = tableIdToColumnNames.get(tableId);
            if (columnNames == null) {
                columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                tableIdToColumnNames.put(tableId, columnNames);
            }
            columnNames.add(this.desc.getColumn().getName());
        }
    }

    public Table getTable() {
        Preconditions.checkState((this.desc != null ? 1 : 0) != 0);
        Table table = this.desc.getParent().getTable();
        return table;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getColumnName() {
        return this.col;
    }

    public void setCol(String col) {
        this.col = col;
    }

    @Override
    public boolean supportSerializable() {
        return true;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.tblName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.tblName.write(out);
        }
        Text.writeString((DataOutput)out, (String)this.col);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.tblName = new TableName();
            this.tblName.readFields(in);
        }
        this.col = Text.readString((DataInput)in);
    }

    public static SlotRef read(DataInput in) throws IOException {
        SlotRef slotRef = new SlotRef();
        slotRef.readFields(in);
        return slotRef;
    }

    @Override
    public boolean isNullable() {
        Preconditions.checkNotNull((Object)this.desc);
        return this.desc.getIsNullable();
    }
}

