/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ColumnStats;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TSlotDescriptor;

public class SlotDescriptor {
    private final SlotId id;
    private final TupleDescriptor parent;
    private Type type;
    private Column column;
    private String label_;
    private List<Expr> sourceExprs_ = Lists.newArrayList();
    private boolean isMaterialized;
    private boolean isNullable;
    private int byteSize;
    private int byteOffset;
    private int nullIndicatorByte;
    private int nullIndicatorBit;
    private int slotIdx;
    private int slotOffset;
    private ColumnStats stats;
    private boolean isAgg;
    private boolean isMultiRef;
    private Type originType;

    public SlotDescriptor(SlotId id, TupleDescriptor parent) {
        this.id = id;
        this.parent = parent;
        this.byteOffset = -1;
        this.isMaterialized = false;
        this.isNullable = true;
        this.isAgg = false;
        this.isMultiRef = false;
    }

    SlotDescriptor(SlotId id, TupleDescriptor parent, SlotDescriptor src) {
        this.id = id;
        this.parent = parent;
        this.byteOffset = src.byteOffset;
        this.nullIndicatorBit = src.nullIndicatorBit;
        this.nullIndicatorByte = src.nullIndicatorByte;
        this.slotIdx = src.slotIdx;
        this.isMaterialized = src.isMaterialized;
        this.column = src.column;
        this.isNullable = src.isNullable;
        this.byteSize = src.byteSize;
        this.isAgg = false;
        this.stats = src.stats;
        this.type = src.type;
    }

    public boolean isMultiRef() {
        return this.isMultiRef;
    }

    public void setMultiRef(boolean isMultiRef) {
        this.isMultiRef = isMultiRef;
    }

    public boolean getIsAgg() {
        return this.isAgg;
    }

    public void setIsAgg(boolean agg) {
        this.isAgg = agg;
    }

    public int getNullIndicatorByte() {
        return this.nullIndicatorByte;
    }

    public void setNullIndicatorByte(int nullIndicatorByte) {
        this.nullIndicatorByte = nullIndicatorByte;
    }

    public int getNullIndicatorBit() {
        return this.nullIndicatorBit;
    }

    public void setNullIndicatorBit(int nullIndicatorBit) {
        this.nullIndicatorBit = nullIndicatorBit;
    }

    public SlotId getId() {
        return this.id;
    }

    public TupleDescriptor getParent() {
        return this.parent;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
        this.type = column.getType();
        this.originType = column.getOriginType();
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public void setIsMaterialized(boolean value) {
        this.isMaterialized = value;
    }

    public boolean getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(boolean value) {
        this.isNullable = value;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int byteSize) {
        this.byteSize = byteSize;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setSlotIdx(int slotIdx) {
        this.slotIdx = slotIdx;
    }

    public void setStats(ColumnStats stats) {
        this.stats = stats;
    }

    public ColumnStats getStats() {
        if (this.stats == null) {
            this.stats = this.column != null ? this.column.getStats() : new ColumnStats();
        }
        this.stats.setNumDistinctValues(this.parent.getCardinality());
        return this.stats;
    }

    public void setSlotOffset(int slotOffset) {
        this.slotOffset = slotOffset;
    }

    public int getSlotOffset() {
        return this.slotOffset;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        this.label_ = label;
    }

    public void setSourceExprs(List<Expr> exprs) {
        this.sourceExprs_ = exprs;
    }

    public void setSourceExpr(Expr expr) {
        this.sourceExprs_ = Collections.singletonList(expr);
    }

    public void addSourceExpr(Expr expr) {
        this.sourceExprs_.add(expr);
    }

    public List<Expr> getSourceExprs() {
        return this.sourceExprs_;
    }

    public void initFromExpr(Expr expr) {
        this.setIsNullable(expr.isNullable());
        this.setLabel(expr.toSql());
        Preconditions.checkState((boolean)this.sourceExprs_.isEmpty());
        this.setSourceExpr(expr);
        this.setStats(ColumnStats.fromExpr(expr));
        Preconditions.checkState((boolean)expr.getType().isValid());
        this.setType(expr.getType());
    }

    public boolean LayoutEquals(SlotDescriptor other) {
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.isNullable != other.isNullable) {
            return false;
        }
        if (this.getByteSize() != other.getByteSize()) {
            return false;
        }
        if (this.getByteOffset() != other.getByteOffset()) {
            return false;
        }
        if (this.getNullIndicatorByte() != other.getNullIndicatorByte()) {
            return false;
        }
        return this.getNullIndicatorBit() == other.getNullIndicatorBit();
    }

    public TSlotDescriptor toThrift() {
        if (this.originType != null) {
            return new TSlotDescriptor(this.id.asInt(), this.parent.getId().asInt(), this.originType.toThrift(), -1, this.byteOffset, this.nullIndicatorByte, this.nullIndicatorBit, this.column != null ? this.column.getName() : "", this.slotIdx, this.isMaterialized);
        }
        return new TSlotDescriptor(this.id.asInt(), this.parent.getId().asInt(), this.type.toThrift(), -1, this.byteOffset, this.nullIndicatorByte, this.nullIndicatorBit, this.column != null ? this.column.getName() : "", this.slotIdx, this.isMaterialized);
    }

    public String debugString() {
        String colStr = this.column == null ? "null" : this.column.getName();
        String typeStr = this.type == null ? "null" : this.type.toString();
        String parentTupleId = this.parent == null ? "null" : this.parent.getId().toString();
        return MoreObjects.toStringHelper((Object)this).add("id", this.id.asInt()).add("parent", (Object)parentTupleId).add("col", (Object)colStr).add("type", (Object)typeStr).add("materialized", this.isMaterialized).add("byteSize", this.byteSize).add("byteOffset", this.byteOffset).add("nullIndicatorByte", this.nullIndicatorByte).add("nullIndicatorBit", this.nullIndicatorBit).add("slotIdx", this.slotIdx).toString();
    }

    public String toString() {
        return this.debugString();
    }

    public String getExplainString(String prefix) {
        StringBuilder builder = new StringBuilder();
        String colStr = this.column == null ? "null" : this.column.getName();
        String typeStr = this.type == null ? "null" : this.type.toString();
        String parentTupleId = this.parent == null ? "null" : this.parent.getId().toString();
        builder.append(prefix).append("SlotDescriptor{").append("id=").append(this.id).append(", col=").append(colStr).append(", type=").append(typeStr).append("}\n");
        prefix = prefix + "  ";
        builder.append(prefix).append("parent=").append(parentTupleId).append("\n");
        builder.append(prefix).append("materialized=").append(this.isMaterialized).append("\n");
        builder.append(prefix).append("byteSize=").append(this.byteSize).append("\n");
        builder.append(prefix).append("byteOffset=").append(this.byteOffset).append("\n");
        builder.append(prefix).append("nullIndicatorByte=").append(this.nullIndicatorByte).append("\n");
        builder.append(prefix).append("nullIndicatorBit=").append(this.nullIndicatorBit).append("\n");
        builder.append(prefix).append("slotIdx=").append(this.slotIdx).append("\n");
        return builder.toString();
    }

    public boolean isScanSlot() {
        Table table = this.parent.getTable();
        return table != null && table instanceof OlapTable;
    }
}

