/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.thrift.TTabletType;

public class SinglePartitionDesc {
    private boolean isAnalyzed;
    private boolean ifNotExists;
    private String partName;
    private PartitionKeyDesc partitionKeyDesc;
    private Map<String, String> properties;
    private DataProperty partitionDataProperty;
    private ReplicaAllocation replicaAlloc;
    private boolean isInMemory = false;
    private TTabletType tabletType = TTabletType.TABLET_TYPE_DISK;
    private Long versionInfo;

    public SinglePartitionDesc(boolean ifNotExists, String partName, PartitionKeyDesc partitionKeyDesc, Map<String, String> properties) {
        this.ifNotExists = ifNotExists;
        this.isAnalyzed = false;
        this.partName = partName;
        this.partitionKeyDesc = partitionKeyDesc;
        this.properties = properties;
        this.partitionDataProperty = DataProperty.DEFAULT_DATA_PROPERTY;
        this.replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
    }

    public boolean isSetIfNotExists() {
        return this.ifNotExists;
    }

    public String getPartitionName() {
        return this.partName;
    }

    public PartitionKeyDesc getPartitionKeyDesc() {
        return this.partitionKeyDesc;
    }

    public DataProperty getPartitionDataProperty() {
        return this.partitionDataProperty;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public boolean isInMemory() {
        return this.isInMemory;
    }

    public TTabletType getTabletType() {
        return this.tabletType;
    }

    public Long getVersionInfo() {
        return this.versionInfo;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void analyze(int partColNum, Map<String, String> otherProperties) throws AnalysisException {
        if (this.isAnalyzed) {
            return;
        }
        FeNameFormat.checkPartitionName(this.partName);
        this.partitionKeyDesc.analyze(partColNum);
        if (otherProperties != null) {
            this.properties = otherProperties;
        }
        this.partitionDataProperty = PropertyAnalyzer.analyzeDataProperty(this.properties, DataProperty.DEFAULT_DATA_PROPERTY);
        Preconditions.checkNotNull((Object)this.partitionDataProperty);
        this.replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(this.properties, "");
        if (this.replicaAlloc.isNotSet()) {
            this.replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
        }
        this.versionInfo = PropertyAnalyzer.analyzeVersionInfo(this.properties);
        this.isInMemory = PropertyAnalyzer.analyzeBooleanProp(this.properties, "in_memory", false);
        this.tabletType = PropertyAnalyzer.analyzeTabletType(this.properties);
        if (otherProperties == null && this.properties != null && !this.properties.isEmpty()) {
            Joiner.MapJoiner mapJoiner = Joiner.on((String)", ").withKeyValueSeparator(" = ");
            throw new AnalysisException("Unknown properties: " + mapJoiner.join(this.properties));
        }
        this.isAnalyzed = true;
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARTITION ").append(this.partName);
        if (this.partitionKeyDesc.getPartitionType() == PartitionKeyDesc.PartitionKeyValueType.LESS_THAN) {
            sb.append(" VALUES LESS THAN ");
        } else {
            sb.append(" VALUES ");
        }
        sb.append(this.partitionKeyDesc.toSql());
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append(" (");
            sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

