/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.View;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowViewStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("View", ScalarType.createVarchar(30))).addColumn(new Column("Create View", ScalarType.createVarchar(65535))).build();
    private String db;
    private TableName tbl;
    private List<View> matchViews = Lists.newArrayList();

    public ShowViewStmt(String db, TableName tbl) {
        this.db = db;
        this.tbl = tbl;
    }

    public String getDb() {
        return this.tbl.getDb();
    }

    public String getTbl() {
        return this.tbl.getTbl();
    }

    public List<View> getMatchViews() {
        return this.matchViews;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (this.tbl == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)this.db)) {
            this.tbl.setDb(this.db);
        }
        this.tbl.analyze(analyzer);
        String dbName = this.tbl.getDb();
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, this.getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW VIEW", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + this.getTbl());
        }
        Database database = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbName);
        database.getOlapTableOrAnalysisException(this.tbl.getTbl());
        for (Table table : database.getViews()) {
            View view = (View)table;
            ArrayList tblRefs = Lists.newArrayList();
            this.getTableRefs(analyzer, view, tblRefs);
            for (TableRef tblRef : tblRefs) {
                tblRef.getName().analyze(analyzer);
                if (!tblRef.getName().equals(this.tbl)) continue;
                this.matchViews.add(view);
            }
        }
    }

    private void getTableRefs(Analyzer analyzer, View view, List<TableRef> tblRefs) {
        HashSet parentViewNameSet = Sets.newHashSet();
        QueryStmt queryStmt = view.getQueryStmt();
        queryStmt.getTableRefs(analyzer, tblRefs, parentViewNameSet);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW VIEW FROM ");
        sb.append(this.tbl.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

