/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FromClause;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowVariablesStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowVariablesStmt.class);
    private static final String NAME_COL = "Variable_name";
    private static final String VALUE_COL = "Value";
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Variable_name", ScalarType.createVarchar(20))).addColumn(new Column("Value", ScalarType.createVarchar(20))).build();
    private SetType type;
    private String pattern;
    private Expr where;
    private SelectStmt selectStmt;

    public ShowVariablesStmt(SetType type, String pattern) {
        this.type = type;
        this.pattern = pattern;
    }

    public ShowVariablesStmt(SetType type, String pattern, Expr where) {
        this.type = type;
        this.pattern = pattern;
        this.where = where;
    }

    public SetType getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) {
        if (this.type == null) {
            this.type = SetType.DEFAULT;
        }
    }

    @Override
    public SelectStmt toSelectStmt(Analyzer analyzer) {
        if (this.where == null) {
            return null;
        }
        if (this.selectStmt != null) {
            return this.selectStmt;
        }
        this.analyze(analyzer);
        SelectList selectList = new SelectList();
        ExprSubstitutionMap aliasMap = new ExprSubstitutionMap(false);
        TableName tableName = null;
        tableName = this.type == SetType.GLOBAL ? new TableName("information_schema", "GLOBAL_VARIABLES") : new TableName("information_schema", "SESSION_VARIABLES");
        SelectListItem item = new SelectListItem(new SlotRef(tableName, "VARIABLE_NAME"), NAME_COL);
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, NAME_COL), item.getExpr().clone(null));
        item = new SelectListItem(new SlotRef(tableName, "VARIABLE_VALUE"), VALUE_COL);
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, VALUE_COL), item.getExpr().clone(null));
        this.where = this.where.substitute(aliasMap);
        this.selectStmt = new SelectStmt(selectList, new FromClause(Lists.newArrayList((Object[])new TableRef[]{new TableRef(tableName, null)})), this.where, null, null, null, LimitElement.NO_LIMIT);
        LOG.debug("select stmt is {}", (Object)this.selectStmt.toSql());
        analyzer.setSchemaInfo(this.type.toSql(), null, null);
        return this.selectStmt;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW ");
        sb.append(this.type.toString()).append(" VARIABLES");
        if (this.pattern != null) {
            sb.append(" LIKE '").append(this.pattern).append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

