/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.UserPropertyProcNode;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowUserPropertyStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowUserPropertyStmt.class);
    private String user;
    private String pattern;

    public ShowUserPropertyStmt(String user, String pattern) {
        this.user = user;
        this.pattern = pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.user)) {
            this.user = analyzer.getQualifiedUser();
        } else {
            this.user = ClusterNamespace.getFullName(this.getClusterName(), this.user);
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
        }
        this.pattern = Strings.emptyToNull((String)this.pattern);
    }

    public List<List<String>> getRows() throws AnalysisException {
        List<List<String>> rows = Catalog.getCurrentCatalog().getAuth().getUserProperties(this.user);
        if (this.pattern == null) {
            return rows;
        }
        ArrayList result = Lists.newArrayList();
        PatternMatcher matcher = PatternMatcher.createMysqlPattern(this.pattern, CaseSensibility.USER.getCaseSensibility());
        for (List<String> row : rows) {
            String key = row.get(0).split("\\.")[0];
            if (!matcher.match(key)) continue;
            result.add(row);
        }
        return result;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String col : UserPropertyProcNode.TITLE_NAMES) {
            builder.addColumn(new Column(col, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW PROPERTY FOR '");
        sb.append(this.user);
        sb.append("'");
        if (this.pattern != null) {
            sb.append(" LIKE '");
            sb.append(this.pattern);
            sb.append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

