/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.TransProcDir;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowTransactionStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowTransactionStmt.class);
    private String dbName;
    private Expr whereClause;
    private long txnId = -1L;
    private String label = "";
    private TransactionStatus status = TransactionStatus.UNKNOWN;

    public ShowTransactionStmt(String dbName, Expr whereClause) {
        this.dbName = dbName;
        this.whereClause = whereClause;
    }

    public String getDbName() {
        return this.dbName;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public String getLabel() {
        return this.label;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (this.whereClause == null) {
            throw new AnalysisException("Missing transaction id");
        }
        this.analyzeWhereClause();
    }

    private void analyzeWhereClause() throws AnalysisException {
        boolean valid;
        block15: {
            block14: {
                block13: {
                    if (this.whereClause == null) {
                        return;
                    }
                    valid = true;
                    if (!(this.whereClause instanceof BinaryPredicate)) break block13;
                    BinaryPredicate binaryPredicate = (BinaryPredicate)this.whereClause;
                    if (binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) break block14;
                    valid = false;
                    break block15;
                }
                valid = false;
                break block15;
            }
            if (!(this.whereClause.getChild(0) instanceof SlotRef)) {
                valid = false;
            } else {
                String leftKey = ((SlotRef)this.whereClause.getChild(0)).getColumnName();
                if (leftKey.equalsIgnoreCase("id") && this.whereClause.getChild(1) instanceof IntLiteral) {
                    this.txnId = ((IntLiteral)this.whereClause.getChild(1)).getLongValue();
                } else if (leftKey.equalsIgnoreCase("label") && this.whereClause.getChild(1) instanceof StringLiteral) {
                    this.label = ((StringLiteral)this.whereClause.getChild(1)).getStringValue();
                } else if (leftKey.equalsIgnoreCase("status") && this.whereClause.getChild(1) instanceof StringLiteral) {
                    String txnStatus = ((StringLiteral)this.whereClause.getChild(1)).getStringValue();
                    try {
                        this.status = TransactionStatus.valueOf(txnStatus.toUpperCase());
                    }
                    catch (Exception e) {
                        throw new AnalysisException("status should be prepare/precommitted/committed/visible/aborted");
                    }
                    if (this.status == TransactionStatus.UNKNOWN) {
                        throw new AnalysisException("status should be prepare/precommitted/committed/visible/aborted");
                    }
                } else {
                    valid = false;
                }
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like one of them: id = 123 or label = 'label' or status = 'prepare/precommitted/committed/visible/aborted'");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW TRANSACTION ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("FROM `").append(this.dbName).append("`");
        }
        sb.append(" WHERE ").append(this.whereClause.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TransProcDir.TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

