/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.TabletsProcDir;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowTabletStmt
extends ShowStmt {
    private String dbName;
    private String tableName;
    private long tabletId;
    private PartitionNames partitionNames;
    private Expr whereClause;
    private List<OrderByElement> orderByElements;
    private LimitElement limitElement;
    private long version;
    private long backendId;
    private String indexName;
    private Replica.ReplicaState replicaState;
    private ArrayList<OrderByPair> orderByPairs;
    private boolean isShowSingleTablet;

    public ShowTabletStmt(TableName dbTableName, long tabletId) {
        this(dbTableName, tabletId, null, null, null, null);
    }

    public ShowTabletStmt(TableName dbTableName, long tabletId, PartitionNames partitionNames, Expr whereClause, List<OrderByElement> orderByElements, LimitElement limitElement) {
        if (dbTableName == null) {
            this.dbName = null;
            this.tableName = null;
            this.isShowSingleTablet = true;
            this.indexName = null;
        } else {
            this.dbName = dbTableName.getDb();
            this.tableName = dbTableName.getTbl();
            this.isShowSingleTablet = false;
            this.indexName = Strings.emptyToNull((String)this.indexName);
        }
        this.tabletId = tabletId;
        this.partitionNames = partitionNames;
        this.whereClause = whereClause;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        this.version = -1L;
        this.backendId = -1L;
        this.indexName = null;
        this.replicaState = null;
        this.orderByPairs = null;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public boolean isShowSingleTablet() {
        return this.isShowSingleTablet;
    }

    public boolean hasOffset() {
        return this.limitElement != null && this.limitElement.hasOffset();
    }

    public long getOffset() {
        return this.limitElement.getOffset();
    }

    public boolean hasPartition() {
        return this.partitionNames != null;
    }

    public PartitionNames getPartitionNames() {
        return this.partitionNames;
    }

    public boolean hasLimit() {
        return this.limitElement != null && this.limitElement.hasLimit();
    }

    public long getLimit() {
        return this.limitElement.getLimit();
    }

    public long getVersion() {
        return this.version;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<OrderByPair> getOrderByPairs() {
        return this.orderByPairs;
    }

    public Replica.ReplicaState getReplicaState() {
        return this.replicaState;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "SHOW TABLET");
        }
        super.analyze(analyzer);
        if (!this.isShowSingleTablet && Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (this.partitionNames != null) {
            this.partitionNames.analyze(analyzer);
        }
        if (this.limitElement != null) {
            this.limitElement.analyze(analyzer);
        }
        if (this.whereClause != null) {
            if (this.whereClause instanceof CompoundPredicate) {
                CompoundPredicate cp = (CompoundPredicate)this.whereClause;
                if (cp.getOp() != CompoundPredicate.Operator.AND) {
                    throw new AnalysisException("Only allow compound predicate with operator AND");
                }
                this.analyzeSubPredicate((Expr)cp.getChild(0));
                this.analyzeSubPredicate((Expr)cp.getChild(1));
            } else {
                this.analyzeSubPredicate(this.whereClause);
            }
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = TabletsProcDir.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
    }

    private void analyzeSubPredicate(Expr subExpr) throws AnalysisException {
        if (subExpr == null) {
            return;
        }
        if (subExpr instanceof CompoundPredicate) {
            CompoundPredicate cp = (CompoundPredicate)subExpr;
            if (cp.getOp() != CompoundPredicate.Operator.AND) {
                throw new AnalysisException("Only allow compound predicate with operator AND");
            }
            this.analyzeSubPredicate((Expr)cp.getChild(0));
            this.analyzeSubPredicate((Expr)cp.getChild(1));
            return;
        }
        boolean valid = true;
        if (!(subExpr instanceof BinaryPredicate)) {
            valid = false;
        } else {
            BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
            if (binaryPredicate.getOp() != BinaryPredicate.Operator.EQ) {
                valid = false;
            } else if (!(subExpr.getChild(0) instanceof SlotRef)) {
                valid = false;
            } else {
                String leftKey = ((SlotRef)subExpr.getChild(0)).getColumnName();
                if (leftKey.equalsIgnoreCase("version")) {
                    if (!(subExpr.getChild(1) instanceof IntLiteral) || this.version > -1L) {
                        valid = false;
                    } else {
                        this.version = ((IntLiteral)subExpr.getChild(1)).getValue();
                    }
                } else if (leftKey.equalsIgnoreCase("backendid")) {
                    if (!(subExpr.getChild(1) instanceof IntLiteral) || this.backendId > -1L) {
                        valid = false;
                    } else {
                        this.backendId = ((IntLiteral)subExpr.getChild(1)).getValue();
                    }
                } else if (leftKey.equalsIgnoreCase("indexname")) {
                    if (!(subExpr.getChild(1) instanceof StringLiteral) || this.indexName != null) {
                        valid = false;
                    } else {
                        this.indexName = ((StringLiteral)subExpr.getChild(1)).getValue();
                    }
                } else if (leftKey.equalsIgnoreCase("state")) {
                    if (!(subExpr.getChild(1) instanceof StringLiteral) || this.replicaState != null) {
                        valid = false;
                    } else {
                        String state = ((StringLiteral)subExpr.getChild(1)).getValue().toUpperCase();
                        try {
                            this.replicaState = Replica.ReplicaState.valueOf(state);
                        }
                        catch (Exception e) {
                            this.replicaState = null;
                            valid = false;
                        }
                    }
                } else {
                    valid = false;
                }
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like: Version = \"version\", or state = \"NORMAL|ROLLUP|CLONE|DECOMMISSION\", or BackendId = 10000, indexname=\"rollup_name\" or compound predicate with operator AND");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW TABLET ");
        if (this.isShowSingleTablet) {
            sb.append(this.tabletId);
        } else {
            sb.append(" FROM ").append("`").append(this.dbName).append("`.`").append(this.tableName).append("`");
        }
        if (this.limitElement != null) {
            if (this.limitElement.hasOffset() && this.limitElement.hasLimit()) {
                sb.append(" ").append(this.limitElement.getOffset()).append(",").append(this.limitElement.getLimit());
            } else if (this.limitElement.hasLimit()) {
                sb.append(" ").append(this.limitElement.getLimit());
            }
        }
        return sb.toString();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        if (this.isShowSingleTablet) {
            builder.addColumn(new Column("DbName", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("TableName", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("PartitionName", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("IndexName", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("DbId", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("TableId", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("PartitionId", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("IndexId", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("IsSync", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("Order", ScalarType.createVarchar(30)));
            builder.addColumn(new Column("DetailCmd", ScalarType.createVarchar(30)));
        } else {
            for (String title : TabletsProcDir.TITLE_NAMES) {
                builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
            }
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        if (ConnectContext.get().getSessionVariable().getForwardToMaster()) {
            return RedirectStatus.FORWARD_NO_SYNC;
        }
        return RedirectStatus.NO_FORWARD;
    }
}

