/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FromClause;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowTableStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowTableStmt.class);
    private static final String NAME_COL_PREFIX = "Tables_in_";
    private static final String TYPE_COL = "Table_type";
    private static final String STORAGE_FORMAT_COL = "StorageFormat";
    private static final TableName TABLE_NAME = new TableName("information_schema", "tables");
    private String db;
    private boolean isVerbose;
    private String pattern;
    private Expr where;
    private SelectStmt selectStmt;

    public ShowTableStmt(String db, boolean isVerbose, String pattern) {
        this.db = db;
        this.isVerbose = isVerbose;
        this.pattern = pattern;
        this.where = null;
    }

    public ShowTableStmt(String db, boolean isVerbose, String pattern, Expr where) {
        this.db = db;
        this.isVerbose = isVerbose;
        this.pattern = pattern;
        this.where = where;
    }

    public String getDb() {
        return this.db;
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.db)) {
            this.db = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.db)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.db = ClusterNamespace.getFullName(analyzer.getClusterName(), this.db);
        }
    }

    @Override
    public SelectStmt toSelectStmt(Analyzer analyzer) throws AnalysisException {
        if (this.where == null) {
            return null;
        }
        if (this.selectStmt != null) {
            return this.selectStmt;
        }
        this.analyze(analyzer);
        SelectList selectList = new SelectList();
        ExprSubstitutionMap aliasMap = new ExprSubstitutionMap(false);
        SelectListItem item = new SelectListItem(new SlotRef(TABLE_NAME, "TABLE_NAME"), NAME_COL_PREFIX + ClusterNamespace.getNameFromFullName(this.db));
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, NAME_COL_PREFIX + ClusterNamespace.getNameFromFullName(this.db)), item.getExpr().clone(null));
        if (this.isVerbose) {
            item = new SelectListItem(new SlotRef(TABLE_NAME, "TABLE_TYPE"), TYPE_COL);
            selectList.addItem(item);
            aliasMap.put(new SlotRef(null, TYPE_COL), item.getExpr().clone(null));
        }
        this.where = this.where.substitute(aliasMap);
        this.selectStmt = new SelectStmt(selectList, new FromClause(Lists.newArrayList((Object[])new TableRef[]{new TableRef(TABLE_NAME, null)})), this.where, null, null, null, LimitElement.NO_LIMIT);
        analyzer.setSchemaInfo(ClusterNamespace.getNameFromFullName(this.db), null, null);
        return this.selectStmt;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW");
        if (this.isVerbose) {
            sb.append(" FULL");
        }
        sb.append(" TABLES");
        if (!Strings.isNullOrEmpty((String)this.db)) {
            sb.append(" FROM ").append(this.db);
        }
        if (this.pattern != null) {
            sb.append(" LIKE '").append(this.pattern).append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        builder.addColumn(new Column(NAME_COL_PREFIX + ClusterNamespace.getNameFromFullName(this.db), ScalarType.createVarchar(20)));
        if (this.isVerbose) {
            builder.addColumn(new Column(TYPE_COL, ScalarType.createVarchar(20)));
            builder.addColumn(new Column(STORAGE_FORMAT_COL, ScalarType.createVarchar(20)));
        }
        return builder.build();
    }
}

