/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.parquet.Preconditions;
import org.apache.parquet.Strings;

public class ShowTableStatsStmt
extends ShowStmt {
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"table_name").add((Object)"row_count").add((Object)"data_size").build();
    private TableName tableName;
    private String dbName;

    public ShowTableStatsStmt(TableName tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        Preconditions.checkArgument((boolean)this.isAnalyzed(), (String)"The db name must be obtained after the parsing is complete");
        if (this.tableName == null) {
            return null;
        }
        return this.tableName.getTbl();
    }

    public String getDbName() {
        Preconditions.checkArgument((boolean)this.isAnalyzed(), (String)"The db name must be obtained after the parsing is complete");
        if (this.tableName == null) {
            return this.dbName;
        }
        return this.tableName.getDb();
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.tableName == null) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            return;
        }
        this.tableName.analyze(analyzer);
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }
}

