/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowTableCreationStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Database", ScalarType.createVarchar(20))).addColumn(new Column("Table", ScalarType.createVarchar(20))).addColumn(new Column("Status", ScalarType.createVarchar(10))).addColumn(new Column("Create Time", ScalarType.createVarchar(20))).addColumn(new Column("Error Msg", ScalarType.createVarchar(100))).build();
    private String dbName;
    private String wild;

    public ShowTableCreationStmt(String db, String wild) {
        this.dbName = db;
        this.wild = wild;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getWild() {
        return this.wild;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
    }

    public boolean like(String str) {
        str = str.toLowerCase();
        return str.matches(this.wild.replace(".", "\\.").replace("?", ".").replace("%", ".*").toLowerCase());
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SHOW TABLE CREATION FROM ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            stringBuilder.append("`").append(this.dbName).append("` ");
        }
        if (!Strings.isNullOrEmpty((String)this.wild)) {
            stringBuilder.append("LIKE ").append("`").append(this.wild).append("`");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

