/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowSqlBlockRuleStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Name", ScalarType.createVarchar(50))).addColumn(new Column("Sql", ScalarType.createVarchar(65535))).addColumn(new Column("SqlHash", ScalarType.createVarchar(65535))).addColumn(new Column("PartitionNum", ScalarType.createVarchar(10))).addColumn(new Column("TabletNum", ScalarType.createVarchar(10))).addColumn(new Column("Cardinality", ScalarType.createVarchar(20))).addColumn(new Column("Global", ScalarType.createVarchar(4))).addColumn(new Column("Enable", ScalarType.createVarchar(4))).build();
    private String ruleName;

    public ShowSqlBlockRuleStmt(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW SQL_BLOCK_RULE");
        if (StringUtils.isNotEmpty((CharSequence)this.ruleName)) {
            sb.append(" FOR ").append(this.ruleName);
        }
        return sb.toString();
    }
}

