/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowSnapshotStmt
extends ShowStmt {
    public static final ImmutableList<String> SNAPSHOT_ALL = new ImmutableList.Builder().add((Object)"Snapshot").add((Object)"Timestamp").add((Object)"Status").build();
    public static final ImmutableList<String> SNAPSHOT_DETAIL = new ImmutableList.Builder().add((Object)"Snapshot").add((Object)"Timestamp").add((Object)"Database").add((Object)"Details").add((Object)"Status").build();
    private String repoName;
    private Expr where;
    private String snapshotName;
    private String timestamp;

    public ShowSnapshotStmt(String repoName, Expr where) {
        this.repoName = repoName;
        this.where = where;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.where != null) {
            boolean ok = true;
            if (this.where instanceof BinaryPredicate) {
                if (!this.analyzeSubExpr((BinaryPredicate)this.where)) {
                    ok = false;
                }
            } else if (this.where instanceof CompoundPredicate) {
                CompoundPredicate cp = (CompoundPredicate)this.where;
                if (cp.getOp() != CompoundPredicate.Operator.AND) {
                    ok = false;
                } else if (!(cp.getChild(0) instanceof BinaryPredicate) || !(cp.getChild(1) instanceof BinaryPredicate)) {
                    ok = false;
                } else if (!this.analyzeSubExpr((BinaryPredicate)cp.getChild(0)) || !this.analyzeSubExpr((BinaryPredicate)cp.getChild(1))) {
                    ok = false;
                }
            }
            if (ok && Strings.isNullOrEmpty((String)this.snapshotName) && !Strings.isNullOrEmpty((String)this.timestamp)) {
                ok = false;
            }
            if (!ok) {
                throw new AnalysisException("Where clause should looks like: SNAPSHOT = 'your_snapshot_name' [AND TIMESTAMP = '2018-04-18-19-19-10']");
            }
        }
    }

    private boolean analyzeSubExpr(BinaryPredicate expr) {
        Expr key = (Expr)expr.getChild(0);
        Expr val = (Expr)expr.getChild(1);
        if (!(key instanceof SlotRef)) {
            return false;
        }
        if (!(val instanceof StringLiteral)) {
            return false;
        }
        String name = ((SlotRef)key).getColumnName();
        if (name.equalsIgnoreCase("snapshot")) {
            this.snapshotName = ((StringLiteral)val).getStringValue();
            return !Strings.isNullOrEmpty((String)this.snapshotName);
        }
        if (name.equalsIgnoreCase("timestamp")) {
            this.timestamp = ((StringLiteral)val).getStringValue();
            return !Strings.isNullOrEmpty((String)this.timestamp);
        }
        return false;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        if (!Strings.isNullOrEmpty((String)this.snapshotName) && !Strings.isNullOrEmpty((String)this.timestamp)) {
            for (String title : SNAPSHOT_DETAIL) {
                builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
            }
        } else {
            for (String title : SNAPSHOT_ALL) {
                builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
            }
        }
        return builder.build();
    }
}

