/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowSmallFilesStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Id", ScalarType.createVarchar(32))).addColumn(new Column("DbName", ScalarType.createVarchar(256))).addColumn(new Column("Catalog", ScalarType.createVarchar(32))).addColumn(new Column("FileName", ScalarType.createVarchar(16))).addColumn(new Column("FileSize", ScalarType.createVarchar(16))).addColumn(new Column("IsContent", ScalarType.createVarchar(16))).addColumn(new Column("MD5", ScalarType.createVarchar(16))).build();
    private String dbName;

    public ShowSmallFilesStmt(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), this.dbName, PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ConnectContext.get().getQualifiedUser(), this.dbName);
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

