/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowRoutineLoadTaskStmt
extends ShowStmt {
    private static final List<String> supportColumn = Arrays.asList("jobname");
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TaskId").add((Object)"TxnId").add((Object)"TxnStatus").add((Object)"JobId").add((Object)"CreateTime").add((Object)"ExecuteStartTime").add((Object)"Timeout").add((Object)"BeId").add((Object)"DataSourceProperties").build();
    private final String dbName;
    private final Expr jobNameExpr;
    private String jobName;
    private String dbFullName;

    public ShowRoutineLoadTaskStmt(String dbName, Expr jobNameExpr) {
        this.dbName = dbName;
        this.jobNameExpr = jobNameExpr;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getDbFullName() {
        return this.dbFullName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.checkDB(analyzer);
        this.checkJobNameExpr(analyzer);
    }

    private void checkDB(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            if (Strings.isNullOrEmpty((String)analyzer.getDefaultDb())) {
                throw new AnalysisException("please designate a database in show stmt");
            }
            this.dbFullName = analyzer.getDefaultDb();
        } else {
            this.dbFullName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
        }
    }

    private void checkJobNameExpr(Analyzer analyzer) throws AnalysisException {
        if (this.jobNameExpr == null) {
            throw new AnalysisException("please designate a jobName in where expr such as JobName=\"ILoveDoris\"");
        }
        boolean valid = true;
        if (!(this.jobNameExpr instanceof BinaryPredicate)) {
            valid = false;
        } else {
            BinaryPredicate binaryPredicate = (BinaryPredicate)this.jobNameExpr;
            if (binaryPredicate.getOp() != BinaryPredicate.Operator.EQ) {
                valid = false;
            } else if (!(binaryPredicate.getChild(0) instanceof SlotRef)) {
                valid = false;
            } else {
                SlotRef slotRef = (SlotRef)binaryPredicate.getChild(0);
                if (!supportColumn.stream().anyMatch(entity -> entity.equals(slotRef.getColumnName().toLowerCase()))) {
                    valid = false;
                } else if (!(binaryPredicate.getChild(1) instanceof StringLiteral)) {
                    valid = false;
                } else {
                    StringLiteral stringLiteral = (StringLiteral)binaryPredicate.getChild(1);
                    this.jobName = stringLiteral.getValue().toLowerCase();
                }
            }
        }
        if (!valid) {
            throw new AnalysisException("show routine load job only support one equal expr which is sames like JobName=\"ILoveDoris\"");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    public static List<String> getTitleNames() {
        return TITLE_NAMES;
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

