/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowRoutineLoadStmt
extends ShowStmt {
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Id").add((Object)"Name").add((Object)"CreateTime").add((Object)"PauseTime").add((Object)"EndTime").add((Object)"DbName").add((Object)"TableName").add((Object)"State").add((Object)"DataSourceType").add((Object)"CurrentTaskNum").add((Object)"JobProperties").add((Object)"DataSourceProperties").add((Object)"CustomProperties").add((Object)"Statistic").add((Object)"Progress").add((Object)"Lag").add((Object)"ReasonOfStateChanged").add((Object)"ErrorLogUrls").add((Object)"OtherMsg").build();
    private final LabelName labelName;
    private String dbFullName;
    private String name;
    private boolean includeHistory = false;
    private String pattern;

    public ShowRoutineLoadStmt(LabelName labelName, boolean includeHistory, String pattern) {
        this.labelName = labelName;
        this.includeHistory = includeHistory;
        this.pattern = pattern;
    }

    public String getDbFullName() {
        return this.dbFullName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncludeHistory() {
        return this.includeHistory;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.checkLabelName(analyzer);
    }

    private void checkLabelName(Analyzer analyzer) throws AnalysisException {
        String dbName;
        String string = dbName = this.labelName == null ? null : this.labelName.getDbName();
        if (Strings.isNullOrEmpty((String)dbName)) {
            this.dbFullName = analyzer.getContext().getDatabase();
            if (Strings.isNullOrEmpty((String)this.dbFullName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbFullName = ClusterNamespace.getFullName(this.getClusterName(), dbName);
        }
        this.name = this.labelName == null ? null : this.labelName.getLabelName();
    }

    public static List<String> getTitleNames() {
        return TITLE_NAMES;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

