/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowRollupStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Table", ScalarType.createVarchar(20))).addColumn(new Column("RollupHandler", ScalarType.createVarchar(30))).addColumn(new Column("Columns", ScalarType.createVarchar(50))).build();
    private TableName tbl;
    private String db;

    public ShowRollupStmt(TableName tbl, String db) {
        this.tbl = tbl;
        this.db = db;
    }

    public String getDb() {
        return this.tbl.getDb();
    }

    public String getTbl() {
        return this.tbl.getTbl();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.tbl == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)this.db)) {
            this.tbl.setDb(this.db);
        }
        this.tbl.analyze(analyzer);
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW ROLLUP FROM ").append(this.tbl.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

