/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.ResourceMgr;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowResourcesStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowResourcesStmt.class);
    private Expr whereClause;
    private LimitElement limitElement;
    private List<OrderByElement> orderByElements;
    private String nameValue;
    private String typeValue;
    private boolean isAccurateMatch;
    private ArrayList<OrderByPair> orderByPairs;

    public ShowResourcesStmt() {
    }

    public ShowResourcesStmt(Expr labelExpr, List<OrderByElement> orderByElements, LimitElement limitElement) {
        this.whereClause = labelExpr;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        this.nameValue = null;
        this.typeValue = null;
        this.isAccurateMatch = false;
    }

    public ArrayList<OrderByPair> getOrderByPairs() {
        return this.orderByPairs;
    }

    public long getLimit() {
        if (this.limitElement != null && this.limitElement.hasLimit()) {
            return this.limitElement.getLimit();
        }
        return -1L;
    }

    public long getOffset() {
        if (this.limitElement != null && this.limitElement.hasOffset()) {
            return this.limitElement.getOffset();
        }
        return -1L;
    }

    public String getNameValue() {
        return this.nameValue;
    }

    public Set<String> getTypeSet() {
        if (Strings.isNullOrEmpty((String)this.typeValue)) {
            return null;
        }
        HashSet<String> resources = new HashSet<String>();
        resources.add(this.typeValue.toUpperCase());
        return resources;
    }

    public boolean isAccurateMatch() {
        return this.isAccurateMatch;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        boolean isValid;
        super.analyze(analyzer);
        if (this.whereClause instanceof CompoundPredicate) {
            CompoundPredicate cp = (CompoundPredicate)this.whereClause;
            if (cp.getOp() != CompoundPredicate.Operator.AND) {
                throw new AnalysisException("Only allow compound predicate with operator AND");
            }
            isValid = this.isWhereClauseValid((Expr)cp.getChild(0)) && this.isWhereClauseValid((Expr)cp.getChild(1));
        } else {
            isValid = this.isWhereClauseValid(this.whereClause);
        }
        if (!isValid) {
            throw new AnalysisException("Where clause should looks like: NAME = \"your_resource_name\", or NAME LIKE \"matcher\",  or RESOURCETYPE = \"resource_type\",  or compound predicate with operator AND");
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = ResourceMgr.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
    }

    private boolean isWhereClauseValid(Expr expr) {
        LikePredicate likePredicate;
        BinaryPredicate binaryPredicate;
        if (expr == null) {
            return true;
        }
        if (!(expr instanceof BinaryPredicate) && !(expr instanceof LikePredicate)) {
            return false;
        }
        if (expr instanceof BinaryPredicate && (binaryPredicate = (BinaryPredicate)expr).getOp() != BinaryPredicate.Operator.EQ) {
            return false;
        }
        if (expr instanceof LikePredicate && (likePredicate = (LikePredicate)expr).getOp() != LikePredicate.Operator.LIKE) {
            return false;
        }
        if (!(expr.getChild(0) instanceof SlotRef)) {
            return false;
        }
        String leftKey = ((SlotRef)expr.getChild(0)).getColumnName();
        if (!(expr.getChild(1) instanceof StringLiteral)) {
            return false;
        }
        String value = ((StringLiteral)expr.getChild(1)).getStringValue();
        if (Strings.isNullOrEmpty((String)value)) {
            return false;
        }
        if (leftKey.equalsIgnoreCase("Name")) {
            if (expr instanceof BinaryPredicate) {
                this.isAccurateMatch = true;
            }
            this.nameValue = value;
            return true;
        }
        if (leftKey.equalsIgnoreCase("ResourceType") && expr instanceof BinaryPredicate) {
            this.typeValue = value.toUpperCase();
            try {
                Resource.ResourceType.valueOf(this.typeValue);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW RESOURCES");
        if (this.whereClause != null) {
            sb.append(" WHERE ").append(this.whereClause.toSql());
        }
        if (this.orderByElements != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                sb.append(this.orderByElements.get(i).getExpr().toSql());
                sb.append(this.orderByElements.get(i).getIsAsc() ? " ASC" : " DESC");
                sb.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.getLimit() != -1L) {
            sb.append(" LIMIT ").append(this.getLimit());
        }
        if (this.getOffset() != -1L) {
            sb.append(" OFFSET ").append(this.getOffset());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : ResourceMgr.RESOURCE_PROC_NODE_TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        if (ConnectContext.get().getSessionVariable().getForwardToMaster()) {
            return RedirectStatus.FORWARD_NO_SYNC;
        }
        return RedirectStatus.NO_FORWARD;
    }
}

