/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowQueryProfileStmt
extends ShowStmt {
    public static final ShowResultSetMetaData META_DATA_QUERY_IDS = ShowResultSetMetaData.builder().addColumn(new Column("QueryId", ScalarType.createVarchar(128))).addColumn(new Column("User", ScalarType.createVarchar(128))).addColumn(new Column("DefaultDb", ScalarType.createVarchar(128))).addColumn(new Column("SQL", ScalarType.createVarchar(65535))).addColumn(new Column("QueryType", ScalarType.createVarchar(128))).addColumn(new Column("StartTime", ScalarType.createVarchar(128))).addColumn(new Column("EndTime", ScalarType.createVarchar(128))).addColumn(new Column("TotalTime", ScalarType.createVarchar(128))).addColumn(new Column("QueryState", ScalarType.createVarchar(128))).build();
    public static final ShowResultSetMetaData META_DATA_FRAGMENTS = ShowResultSetMetaData.builder().addColumn(new Column("Fragments", ScalarType.createVarchar(65535))).build();
    public static final ShowResultSetMetaData META_DATA_INSTANCES = ShowResultSetMetaData.builder().addColumn(new Column("Instances", ScalarType.createVarchar(128))).addColumn(new Column("Host", ScalarType.createVarchar(64))).addColumn(new Column("ActiveTime", ScalarType.createVarchar(64))).build();
    public static final ShowResultSetMetaData META_DATA_SINGLE_INSTANCE = ShowResultSetMetaData.builder().addColumn(new Column("Instance", ScalarType.createVarchar(65535))).build();
    private String queryIdPath;
    private PathType pathType;
    private String queryId = "";
    private String fragmentId = "";
    private String instanceId = "";

    public ShowQueryProfileStmt(String queryIdPath) {
        this.queryIdPath = queryIdPath;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.queryIdPath)) {
            this.pathType = PathType.QUERY_IDS;
            return;
        }
        if (!this.queryIdPath.startsWith("/")) {
            throw new AnalysisException("Query path must starts with '/'");
        }
        this.pathType = PathType.QUERY_IDS;
        String[] parts = this.queryIdPath.split("/");
        if (parts.length > 4) {
            throw new AnalysisException("Query path must in format '/queryId/fragmentId/instanceId'");
        }
        block6: for (int i = 0; i < parts.length; ++i) {
            switch (i) {
                case 0: {
                    this.pathType = PathType.QUERY_IDS;
                    continue block6;
                }
                case 1: {
                    this.queryId = parts[i];
                    this.pathType = PathType.FRAGMETNS;
                    continue block6;
                }
                case 2: {
                    this.fragmentId = parts[i];
                    this.pathType = PathType.INSTANCES;
                    continue block6;
                }
                case 3: {
                    this.instanceId = parts[i];
                    this.pathType = PathType.SINGLE_INSTANCE;
                    continue block6;
                }
            }
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW QUERY PROFILE ").append(this.queryIdPath);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        switch (this.pathType) {
            case QUERY_IDS: {
                return META_DATA_QUERY_IDS;
            }
            case FRAGMETNS: {
                return META_DATA_FRAGMENTS;
            }
            case INSTANCES: {
                return META_DATA_INSTANCES;
            }
            case SINGLE_INSTANCE: {
                return META_DATA_SINGLE_INSTANCE;
            }
        }
        return null;
    }

    public static enum PathType {
        QUERY_IDS,
        FRAGMETNS,
        INSTANCES,
        SINGLE_INSTANCE;

    }
}

