/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.PartitionsProcDir;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowPartitionsStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowPartitionsStmt.class);
    private static final String FILTER_PARTITION_ID = "PartitionId";
    private static final String FILTER_PARTITION_NAME = "PartitionName";
    private static final String FILTER_STATE = "State";
    private static final String FILTER_BUCKETS = "Buckets";
    private static final String FILTER_REPLICATION_NUM = "ReplicationNum";
    private static final String FILTER_LAST_CONSISTENCY_CHECK_TIME = "LastConsistencyCheckTime";
    private String dbName;
    private String tableName;
    private Expr whereClause;
    private List<OrderByElement> orderByElements;
    private LimitElement limitElement;
    private boolean isTempPartition = false;
    private List<OrderByPair> orderByPairs;
    private Map<String, Expr> filterMap;
    private ProcNodeInterface node;

    public ShowPartitionsStmt(TableName tableName, Expr whereClause, List<OrderByElement> orderByElements, LimitElement limitElement, boolean isTempPartition) {
        this.dbName = tableName.getDb();
        this.tableName = tableName.getTbl();
        this.whereClause = whereClause;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        if (whereClause != null) {
            this.filterMap = new HashMap<String, Expr>();
        }
        this.isTempPartition = isTempPartition;
    }

    public List<OrderByPair> getOrderByPairs() {
        return this.orderByPairs;
    }

    public LimitElement getLimitElement() {
        return this.limitElement;
    }

    public Map<String, Expr> getFilterMap() {
        return this.filterMap;
    }

    public ProcNodeInterface getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        this.analyzeImpl(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbName, this.tableName, PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW PARTITIONS", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.dbName + ": " + this.tableName);
        }
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.dbName);
        Object table = db.getTableOrMetaException(this.tableName, Table.TableType.OLAP);
        ((Table)table).readLock();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/dbs/");
            stringBuilder.append(db.getId());
            stringBuilder.append("/").append(((Table)table).getId());
            if (this.isTempPartition) {
                stringBuilder.append("/temp_partitions");
            } else {
                stringBuilder.append("/partitions");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("process SHOW PROC '{}';", (Object)stringBuilder.toString());
            }
            this.node = ProcService.getInstance().open(stringBuilder.toString());
        }
        finally {
            ((Table)table).readUnlock();
        }
    }

    public void analyzeImpl(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (this.whereClause != null) {
            this.analyzeSubPredicate(this.whereClause);
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList<OrderByPair>();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = PartitionsProcDir.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
        if (this.limitElement != null) {
            this.limitElement.analyze(analyzer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeSubPredicate(Expr subExpr) throws AnalysisException {
        if (subExpr == null) {
            return;
        }
        if (subExpr instanceof CompoundPredicate) {
            CompoundPredicate cp = (CompoundPredicate)subExpr;
            if (cp.getOp() != CompoundPredicate.Operator.AND) {
                throw new AnalysisException("Only allow compound predicate with operator AND");
            }
            this.analyzeSubPredicate((Expr)cp.getChild(0));
            this.analyzeSubPredicate((Expr)cp.getChild(1));
            return;
        }
        if (!(subExpr.getChild(0) instanceof SlotRef)) {
            throw new AnalysisException("Show filter by column");
        }
        String leftKey = ((SlotRef)subExpr.getChild(0)).getColumnName();
        if (subExpr instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
            if (leftKey.equalsIgnoreCase(FILTER_PARTITION_NAME) || leftKey.equalsIgnoreCase(FILTER_STATE)) {
                if (binaryPredicate.getOp() != BinaryPredicate.Operator.EQ) {
                    throw new AnalysisException(String.format("Only operator =|like are supported for %s", leftKey));
                }
            } else if (leftKey.equalsIgnoreCase(FILTER_LAST_CONSISTENCY_CHECK_TIME)) {
                if (!(subExpr.getChild(1) instanceof StringLiteral)) {
                    throw new AnalysisException("Where clause : LastConsistencyCheckTime =|>=|<=|>|<|!= \"2019-12-22|2019-12-22 22:22:00\"");
                }
                subExpr.setChild(1, ((Expr)subExpr.getChild(1)).castTo(Type.DATETIME));
            } else if (!(leftKey.equalsIgnoreCase(FILTER_PARTITION_ID) || leftKey.equalsIgnoreCase(FILTER_BUCKETS) || leftKey.equalsIgnoreCase(FILTER_REPLICATION_NUM))) {
                throw new AnalysisException("Only the columns of PartitionId/PartitionName/State/Buckets/ReplicationNum/LastConsistencyCheckTime are supported.");
            }
        } else {
            if (!(subExpr instanceof LikePredicate)) throw new AnalysisException("Only operator =|>=|<=|>|<|!=|like are supported.");
            LikePredicate likePredicate = (LikePredicate)subExpr;
            if (!leftKey.equalsIgnoreCase(FILTER_PARTITION_NAME) && !leftKey.equalsIgnoreCase(FILTER_STATE)) throw new AnalysisException("Where clause : PartitionName|State like \"p20191012|NORMAL\"");
            if (likePredicate.getOp() != LikePredicate.Operator.LIKE) {
                throw new AnalysisException("Where clause : PartitionName|State like \"p20191012|NORMAL\"");
            }
        }
        this.filterMap.put(leftKey.toLowerCase(), subExpr);
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        ProcResult result = null;
        try {
            result = this.node.fetchResult();
        }
        catch (AnalysisException e) {
            return builder.build();
        }
        for (String col : result.getColumnNames()) {
            builder.addColumn(new Column(col, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW ");
        if (this.isTempPartition) {
            sb.append("TEMPORARY ");
        }
        sb.append("PARTITIONS FROM ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("`").append(this.dbName).append("`");
        }
        if (!Strings.isNullOrEmpty((String)this.tableName)) {
            sb.append(".`").append(this.tableName).append("`");
        }
        if (this.whereClause != null) {
            sb.append(" WHERE ").append(this.whereClause.toSql());
        }
        if (this.orderByElements != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                sb.append(this.orderByElements.get(i).toSql());
                sb.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.limitElement != null) {
            sb.append(this.limitElement.toSql());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

