/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowMigrationsStmt
extends ShowStmt {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"cluster").add((Object)"srcdb").add((Object)"desdb").add((Object)"progress").build();

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        ImmutableList<String> titleNames = null;
        titleNames = TITLE_NAMES;
        for (String title : titleNames) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public SelectStmt toSelectStmt(Analyzer analyzer) throws AnalysisException {
        return super.toSelectStmt(analyzer);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
    }
}

