/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowLoadWarningsStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowLoadWarningsStmt.class);
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("JobId", ScalarType.createVarchar(15))).addColumn(new Column("Label", ScalarType.createVarchar(15))).addColumn(new Column("ErrorMsgDetail", ScalarType.createVarchar(100))).build();
    private String dbName;
    private String rawUrl;
    private URL url;
    private Expr whereClause;
    private LimitElement limitElement;
    private String label;
    private long jobId;

    public ShowLoadWarningsStmt(String db, String url, Expr labelExpr, LimitElement limitElement) {
        this.dbName = db;
        this.rawUrl = url;
        this.whereClause = labelExpr;
        this.limitElement = limitElement;
        this.label = null;
        this.jobId = 0L;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getLabel() {
        return this.label;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getLimitNum() {
        if (this.limitElement != null && this.limitElement.hasLimit()) {
            return this.limitElement.getLimit();
        }
        return -1L;
    }

    public boolean isFindByLabel() {
        return this.label != null;
    }

    public boolean isFindByJobId() {
        return this.jobId != 0L;
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (this.rawUrl != null) {
            if (this.rawUrl.isEmpty()) {
                throw new AnalysisException("Error load url is missing");
            }
            if (this.dbName != null || this.whereClause != null || this.limitElement != null) {
                throw new AnalysisException("Can not set database, where or limit clause if getting error log from url");
            }
            this.analyzeUrl();
        } else {
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                this.dbName = analyzer.getDefaultDb();
                if (Strings.isNullOrEmpty((String)this.dbName)) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
                }
            } else {
                this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
            }
            if (this.whereClause == null) {
                throw new AnalysisException("should supply condition like: LABEL = \"your_load_label\", or LOAD_JOB_ID = $job_id");
            }
            if (this.whereClause != null) {
                if (this.whereClause instanceof CompoundPredicate) {
                    CompoundPredicate cp = (CompoundPredicate)this.whereClause;
                    if (cp.getOp() != CompoundPredicate.Operator.AND) {
                        throw new AnalysisException("Only allow compound predicate with operator AND");
                    }
                    this.analyzeSubPredicate((Expr)cp.getChild(0));
                    this.analyzeSubPredicate((Expr)cp.getChild(1));
                } else {
                    this.analyzeSubPredicate(this.whereClause);
                }
            }
        }
    }

    private void analyzeUrl() throws AnalysisException {
        try {
            this.url = new URL(this.rawUrl);
        }
        catch (MalformedURLException e) {
            throw new AnalysisException("Invalid url: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void analyzeSubPredicate(Expr subExpr) throws AnalysisException {
        block4: {
            block11: {
                block13: {
                    block12: {
                        block9: {
                            block10: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block3: {
                                                    valid = false;
                                                    hasLabel = false;
                                                    hasLoadJobId = false;
                                                    if (subExpr != null) break block3;
                                                    valid = false;
                                                    break block4;
                                                }
                                                if (!(subExpr instanceof BinaryPredicate)) break block5;
                                                binaryPredicate = (BinaryPredicate)subExpr;
                                                if (binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) break block6;
                                                valid = false;
                                                break block4;
                                            }
                                            valid = false;
                                            break block4;
                                        }
                                        if (subExpr.getChild(0) instanceof SlotRef) break block7;
                                        valid = false;
                                        break block4;
                                    }
                                    leftKey = ((SlotRef)subExpr.getChild(0)).getColumnName();
                                    if (!leftKey.equalsIgnoreCase("label")) break block8;
                                    hasLabel = true;
                                    break block9;
                                }
                                if (leftKey.equalsIgnoreCase("load_job_id")) break block10;
                                valid = false;
                                break block4;
                            }
                            hasLoadJobId = true;
                        }
                        if (!hasLabel) break block11;
                        if (subExpr.getChild(1) instanceof StringLiteral) break block12;
                        valid = false;
                        break block4;
                    }
                    value = ((StringLiteral)subExpr.getChild(1)).getStringValue();
                    if (!Strings.isNullOrEmpty((String)value)) break block13;
                    valid = false;
                    break block4;
                }
                this.label = value;
            }
            if (!hasLoadJobId) ** GOTO lbl50
            if (!(subExpr.getChild(1) instanceof IntLiteral)) {
                ShowLoadWarningsStmt.LOG.warn("load_job_id is not IntLiteral. value: {}", (Object)subExpr.toSql());
                valid = false;
            } else {
                this.jobId = ((IntLiteral)subExpr.getChild(1)).getLongValue();
lbl50:
                // 2 sources

                valid = true;
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like: LABEL = \"your_load_label\", or LOAD_JOB_ID = $job_id");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

