/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.LoadProcDir;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.load.LoadJob;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowLoadStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowLoadStmt.class);
    private String dbName;
    private Expr whereClause;
    private LimitElement limitElement;
    private List<OrderByElement> orderByElements;
    private String labelValue;
    private String stateValue;
    private boolean isAccurateMatch;
    private ArrayList<OrderByPair> orderByPairs;

    public ShowLoadStmt(String db, Expr labelExpr, List<OrderByElement> orderByElements, LimitElement limitElement) {
        this.dbName = db;
        this.whereClause = labelExpr;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        this.labelValue = null;
        this.stateValue = null;
        this.isAccurateMatch = false;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ArrayList<OrderByPair> getOrderByPairs() {
        return this.orderByPairs;
    }

    public long getLimit() {
        if (this.limitElement != null && this.limitElement.hasLimit()) {
            return this.limitElement.getLimit();
        }
        return -1L;
    }

    public long getOffset() {
        if (this.limitElement != null && this.limitElement.hasOffset()) {
            return this.limitElement.getOffset();
        }
        return -1L;
    }

    public String getLabelValue() {
        return this.labelValue;
    }

    public Set<LoadJob.JobState> getStates() {
        if (Strings.isNullOrEmpty((String)this.stateValue)) {
            return null;
        }
        HashSet<LoadJob.JobState> states = new HashSet<LoadJob.JobState>();
        LoadJob.JobState state = LoadJob.JobState.valueOf(this.stateValue);
        states.add(state);
        if (state == LoadJob.JobState.FINISHED) {
            states.add(LoadJob.JobState.QUORUM_FINISHED);
        }
        return states;
    }

    public boolean isAccurateMatch() {
        return this.isAccurateMatch;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (this.whereClause != null) {
            if (this.whereClause instanceof CompoundPredicate) {
                CompoundPredicate cp = (CompoundPredicate)this.whereClause;
                if (cp.getOp() != CompoundPredicate.Operator.AND) {
                    throw new AnalysisException("Only allow compound predicate with operator AND");
                }
                this.checkPredicateName((Expr)cp.getChild(0), (Expr)cp.getChild(1));
                this.analyzeSubPredicate((Expr)cp.getChild(0));
                this.analyzeSubPredicate((Expr)cp.getChild(1));
            } else {
                this.analyzeSubPredicate(this.whereClause);
            }
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = LoadProcDir.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
    }

    private void checkPredicateName(Expr leftChild, Expr rightChild) throws AnalysisException {
        String rightChildColumnName;
        String leftChildColumnName = ((SlotRef)leftChild.getChild(0)).getColumnName();
        if (leftChildColumnName.equals(rightChildColumnName = ((SlotRef)rightChild.getChild(0)).getColumnName())) {
            throw new AnalysisException("column names on both sides of operator AND should be diffrent");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void analyzeSubPredicate(Expr subExpr) throws AnalysisException {
        block19: {
            block22: {
                block21: {
                    block18: {
                        block20: {
                            block17: {
                                if (subExpr == null) {
                                    return;
                                }
                                valid = true;
                                hasLabel = false;
                                hasState = false;
                                if (!(subExpr instanceof BinaryPredicate)) break block17;
                                binaryPredicate = (BinaryPredicate)subExpr;
                                if (binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) break block18;
                                valid = false;
                                break block19;
                            }
                            if (!(subExpr instanceof LikePredicate)) break block20;
                            likePredicate = (LikePredicate)subExpr;
                            if (likePredicate.getOp() == LikePredicate.Operator.LIKE) break block18;
                            valid = false;
                            break block19;
                        }
                        valid = false;
                        break block19;
                    }
                    if (subExpr.getChild(0) instanceof SlotRef) break block21;
                    valid = false;
                    break block19;
                }
                leftKey = ((SlotRef)subExpr.getChild(0)).getColumnName();
                if (!leftKey.equalsIgnoreCase("label")) break block22;
                hasLabel = true;
                ** GOTO lbl34
            }
            if (!leftKey.equalsIgnoreCase("state")) {
                valid = false;
            } else {
                hasState = true;
lbl34:
                // 2 sources

                if (hasState && !(subExpr instanceof BinaryPredicate)) {
                    valid = false;
                } else {
                    if (hasLabel && subExpr instanceof BinaryPredicate) {
                        this.isAccurateMatch = true;
                    }
                    if (!(subExpr.getChild(1) instanceof StringLiteral)) {
                        valid = false;
                    } else {
                        value = ((StringLiteral)subExpr.getChild(1)).getStringValue();
                        if (Strings.isNullOrEmpty((String)value)) {
                            valid = false;
                        } else {
                            if (hasLabel && !this.isAccurateMatch && !value.contains("%")) {
                                value = "%" + value + "%";
                            }
                            if (hasLabel) {
                                this.labelValue = value;
                            } else if (hasState) {
                                this.stateValue = value.toUpperCase();
                                try {
                                    LoadJob.JobState.valueOf(this.stateValue);
                                }
                                catch (Exception e) {
                                    valid = false;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like: LABEL = \"your_load_label\", or LABEL LIKE \"matcher\",  or STATE = \"PENDING|ETL|LOADING|FINISHED|CANCELLED\",  or compound predicate with operator AND");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW LOAD ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("FROM `").append(this.dbName).append("`");
        }
        if (this.whereClause != null) {
            sb.append(" WHERE ").append(this.whereClause.toSql());
        }
        if (this.orderByElements != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                sb.append(this.orderByElements.get(i).getExpr().toSql());
                sb.append(this.orderByElements.get(i).getIsAsc() ? " ASC" : " DESC");
                sb.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.getLimit() != -1L) {
            sb.append(" LIMIT ").append(this.getLimit());
        }
        if (this.getOffset() != -1L) {
            sb.append(" OFFSET ").append(this.getOffset());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : LoadProcDir.TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

