/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowQueryProfileStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowLoadProfileStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA_TASK_IDS = ShowResultSetMetaData.builder().addColumn(new Column("TaskId", ScalarType.createVarchar(128))).addColumn(new Column("ActiveTime", ScalarType.createVarchar(64))).build();
    private String idPath;
    private PathType pathType;
    private String jobId = "";
    private String taskId = "";
    private String instanceId = "";

    public ShowLoadProfileStmt(String idPath) {
        this.idPath = idPath;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.idPath)) {
            this.pathType = PathType.JOB_IDS;
            return;
        }
        if (!this.idPath.startsWith("/")) {
            throw new AnalysisException("Path must starts with '/'");
        }
        this.pathType = PathType.JOB_IDS;
        String[] parts = this.idPath.split("/");
        if (parts.length > 4) {
            throw new AnalysisException("Path must in format '/jobId/taskId/instanceId'");
        }
        block6: for (int i = 0; i < parts.length; ++i) {
            switch (i) {
                case 0: {
                    this.pathType = PathType.JOB_IDS;
                    continue block6;
                }
                case 1: {
                    this.jobId = parts[i];
                    this.pathType = PathType.TASK_IDS;
                    continue block6;
                }
                case 2: {
                    this.taskId = parts[i];
                    this.pathType = PathType.INSTANCES;
                    continue block6;
                }
                case 3: {
                    this.instanceId = parts[i];
                    this.pathType = PathType.SINGLE_INSTANCE;
                    continue block6;
                }
            }
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW LOAD PROFILE ").append(this.idPath);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        switch (this.pathType) {
            case JOB_IDS: {
                return ShowQueryProfileStmt.META_DATA_QUERY_IDS;
            }
            case TASK_IDS: {
                return META_DATA_TASK_IDS;
            }
            case INSTANCES: {
                return ShowQueryProfileStmt.META_DATA_INSTANCES;
            }
            case SINGLE_INSTANCE: {
                return ShowQueryProfileStmt.META_DATA_SINGLE_INSTANCE;
            }
        }
        return null;
    }

    public static enum PathType {
        JOB_IDS,
        TASK_IDS,
        INSTANCES,
        SINGLE_INSTANCE;

    }
}

