/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowIndexStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Table", ScalarType.createVarchar(64))).addColumn(new Column("Non_unique", ScalarType.createVarchar(10))).addColumn(new Column("Key_name", ScalarType.createVarchar(80))).addColumn(new Column("Seq_in_index", ScalarType.createVarchar(64))).addColumn(new Column("Column_name", ScalarType.createVarchar(80))).addColumn(new Column("Collation", ScalarType.createVarchar(80))).addColumn(new Column("Cardinality", ScalarType.createVarchar(80))).addColumn(new Column("Sub_part", ScalarType.createVarchar(80))).addColumn(new Column("Packed", ScalarType.createVarchar(80))).addColumn(new Column("Null", ScalarType.createVarchar(80))).addColumn(new Column("Index_type", ScalarType.createVarchar(80))).addColumn(new Column("Comment", ScalarType.createVarchar(80))).build();
    private String dbName;
    private TableName tableName;

    public ShowIndexStmt(String dbName, TableName tableName) {
        this.dbName = dbName;
        this.tableName = tableName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            this.tableName.setDb(this.dbName);
        }
        this.tableName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tableName.getDb(), this.tableName.getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, analyzer.getQualifiedUser(), this.tableName.getDb() + ": " + this.tableName.toString());
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SHOW INDEX FROM ");
        sb.append(this.tableName.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public String getDbName() {
        return this.tableName.getDb();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

