/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.proc.AuthProcDir;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowGrantsStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA;
    private boolean isAll;
    private UserIdentity userIdent;

    public ShowGrantsStmt(UserIdentity userIdent, boolean isAll) {
        this.userIdent = userIdent;
        this.isAll = isAll;
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.userIdent != null) {
            if (this.isAll) {
                throw new AnalysisException("Can not specified keyword ALL when specified user");
            }
            this.userIdent.analyze(analyzer.getClusterName());
        } else if (!this.isAll) {
            this.userIdent = ConnectContext.get().getCurrentUserIdentity();
        }
        Preconditions.checkState((this.isAll || this.userIdent != null ? 1 : 0) != 0);
        UserIdentity self = ConnectContext.get().getCurrentUserIdentity();
        if (!(!this.isAll && self.equals(this.userIdent) || Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT))) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }

    static {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String col : AuthProcDir.TITLE_NAMES) {
            builder.addColumn(new Column(col, ScalarType.createVarchar(100)));
        }
        META_DATA = builder.build();
    }
}

