/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowFunctionsStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Signature", ScalarType.createVarchar(256))).addColumn(new Column("Return Type", ScalarType.createVarchar(32))).addColumn(new Column("Function Type", ScalarType.createVarchar(16))).addColumn(new Column("Intermediate Type", ScalarType.createVarchar(16))).addColumn(new Column("Properties", ScalarType.createVarchar(16))).build();
    private String dbName;
    private boolean isBuiltin;
    private boolean isVerbose;
    private String wild;
    private Expr expr;

    public ShowFunctionsStmt(String dbName, boolean isBuiltin, boolean isVerbose, String wild, Expr expr) {
        this.dbName = dbName;
        this.isBuiltin = isBuiltin;
        this.isVerbose = isVerbose;
        this.wild = wild;
        this.expr = expr;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean getIsBuiltin() {
        return this.isBuiltin;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public String getWild() {
        return this.wild;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public boolean like(String str) {
        str = str.toLowerCase();
        return str.matches(this.wild.replace(".", "\\.").replace("?", ".").replace("%", ".*").toLowerCase());
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), this.dbName, PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ConnectContext.get().getQualifiedUser(), this.dbName);
        }
        if (this.expr != null) {
            throw new AnalysisException("Only support like 'function_pattern' syntax.");
        }
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW ");
        if (this.isVerbose) {
            sb.append("FULL ");
        }
        if (this.isBuiltin) {
            sb.append("BUILTIN ");
        }
        sb.append("FUNCTIONS FROM ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("`").append(this.dbName).append("` ");
        }
        if (this.wild != null) {
            sb.append("LIKE ").append("`").append(this.wild).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

