/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.ExportProcNode;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.load.ExportJob;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowExportStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowExportStmt.class);
    private String dbName;
    private final Expr whereClause;
    private final LimitElement limitElement;
    private final List<OrderByElement> orderByElements;
    private long jobId = 0L;
    private String label = null;
    private boolean isLabelUseLike = false;
    private String stateValue = null;
    private ExportJob.JobState jobState;
    private ArrayList<OrderByPair> orderByPairs;

    public ShowExportStmt(String db, Expr whereExpr, List<OrderByElement> orderByElements, LimitElement limitElement) {
        this.dbName = db;
        this.whereClause = whereExpr;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
    }

    public String getDbName() {
        return this.dbName;
    }

    public ArrayList<OrderByPair> getOrderByPairs() {
        return this.orderByPairs;
    }

    public long getLimit() {
        if (this.limitElement != null && this.limitElement.hasLimit()) {
            return this.limitElement.getLimit();
        }
        return -1L;
    }

    public long getJobId() {
        return this.jobId;
    }

    public ExportJob.JobState getJobState() {
        if (Strings.isNullOrEmpty((String)this.stateValue)) {
            return null;
        }
        return this.jobState;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLabelUseLike() {
        return this.isLabelUseLike;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (this.whereClause != null) {
            this.analyzePredicate(this.whereClause);
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = ExportProcNode.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
    }

    private void analyzePredicate(Expr whereExpr) throws AnalysisException {
        if (whereExpr == null) {
            return;
        }
        boolean valid = false;
        if (whereExpr.getChild(0) instanceof SlotRef) {
            String leftKey = ((SlotRef)whereExpr.getChild(0)).getColumnName().toLowerCase();
            if (whereExpr instanceof BinaryPredicate && ((BinaryPredicate)whereExpr).getOp() == BinaryPredicate.Operator.EQ) {
                if ("id".equals(leftKey) && whereExpr.getChild(1) instanceof IntLiteral) {
                    this.jobId = ((IntLiteral)whereExpr.getChild(1)).getLongValue();
                    valid = true;
                } else if ("state".equals(leftKey) && whereExpr.getChild(1) instanceof StringLiteral) {
                    String value = ((Expr)whereExpr.getChild(1)).getStringValue();
                    if (!Strings.isNullOrEmpty((String)value)) {
                        this.stateValue = value.toUpperCase();
                        try {
                            this.jobState = ExportJob.JobState.valueOf(this.stateValue);
                            valid = true;
                        }
                        catch (IllegalArgumentException e) {
                            LOG.warn("illegal state argument in export stmt. stateValue={}, error={}", (Object)this.stateValue, (Object)e);
                        }
                    }
                } else if ("label".equals(leftKey) && whereExpr.getChild(1) instanceof StringLiteral) {
                    this.label = ((Expr)whereExpr.getChild(1)).getStringValue();
                    valid = true;
                }
            } else if (whereExpr instanceof LikePredicate && ((LikePredicate)whereExpr).getOp() == LikePredicate.Operator.LIKE && "label".equals(leftKey) && whereExpr.getChild(1) instanceof StringLiteral) {
                this.label = ((Expr)whereExpr.getChild(1)).getStringValue();
                this.isLabelUseLike = true;
                valid = true;
            }
        }
        if (!valid) {
            throw new AnalysisException("Where clause should looks like below:  ID = $your_job_id, or STATE = \"PENDING|EXPORTING|FINISHED|CANCELLED\", or LABEL = \"xxx\" or LABEL like \"xxx%\"");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW EXPORT ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("FROM `").append(this.dbName).append("`");
        }
        if (this.whereClause != null) {
            sb.append(" WHERE ").append(this.whereClause.toSql());
        }
        if (this.orderByElements != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                sb.append(this.orderByElements.get(i).getExpr().toSql());
                sb.append(this.orderByElements.get(i).getIsAsc() ? " ASC" : " DESC");
                sb.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.getLimit() != -1L) {
            sb.append(" LIMIT ").append(this.getLimit());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : ExportProcNode.TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

