/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowDynamicPartitionStmt
extends ShowStmt {
    private String db;
    private static final ShowResultSetMetaData SHOW_DYNAMIC_PARTITION_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("TableName", ScalarType.createVarchar(20))).addColumn(new Column("Enable", ScalarType.createVarchar(20))).addColumn(new Column("TimeUnit", ScalarType.createVarchar(20))).addColumn(new Column("Start", ScalarType.createVarchar(20))).addColumn(new Column("End", ScalarType.createVarchar(20))).addColumn(new Column("Prefix", ScalarType.createVarchar(20))).addColumn(new Column("Buckets", ScalarType.createVarchar(20))).addColumn(new Column("ReplicationNum", ScalarType.createVarchar(20))).addColumn(new Column("ReplicaAllocation", ScalarType.createVarchar(128))).addColumn(new Column("StartOf", ScalarType.createVarchar(20))).addColumn(new Column("LastUpdateTime", ScalarType.createVarchar(20))).addColumn(new Column("LastSchedulerTime", ScalarType.createVarchar(20))).addColumn(new Column("State", ScalarType.createVarchar(20))).addColumn(new Column("LastCreatePartitionMsg", ScalarType.createVarchar(20))).addColumn(new Column("LastDropPartitionMsg", ScalarType.createVarchar(20))).addColumn(new Column("ReservedHistoryPeriods", ScalarType.createVarchar(20))).build();

    ShowDynamicPartitionStmt(String db) {
        this.db = db;
    }

    public String getDb() {
        return this.db;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.db)) {
            this.db = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.db)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.db = ClusterNamespace.getFullName(analyzer.getClusterName(), this.db);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW DYNAMIC PARTITION TABLES");
        if (!Strings.isNullOrEmpty((String)this.db)) {
            sb.append(" FROM ").append(this.db);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return SHOW_DYNAMIC_PARTITION_META_DATA;
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

