/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowDataStmt
extends ShowStmt {
    private static final ShowResultSetMetaData SHOW_TABLE_DATA_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("TableName", ScalarType.createVarchar(20))).addColumn(new Column("Size", ScalarType.createVarchar(30))).addColumn(new Column("ReplicaCount", ScalarType.createVarchar(20))).build();
    private static final ShowResultSetMetaData SHOW_INDEX_DATA_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("TableName", ScalarType.createVarchar(20))).addColumn(new Column("IndexName", ScalarType.createVarchar(20))).addColumn(new Column("Size", ScalarType.createVarchar(30))).addColumn(new Column("ReplicaCount", ScalarType.createVarchar(20))).addColumn(new Column("RowCount", ScalarType.createVarchar(20))).build();
    public static final ImmutableList<String> SHOW_TABLE_DATA_META_DATA_ORIGIN = new ImmutableList.Builder().add((Object)"TableName").add((Object)"Size").add((Object)"ReplicaCount").build();
    public static final ImmutableList<String> SHOW_INDEX_DATA_META_DATA_ORIGIN = new ImmutableList.Builder().add((Object)"TableName").add((Object)"IndexName").add((Object)"Size").add((Object)"ReplicaCount").add((Object)"RowCount").build();
    private String dbName;
    private String tableName;
    List<List<String>> totalRows;
    List<List<Object>> totalRowsObject = Lists.newArrayList();
    private List<OrderByElement> orderByElements;
    private List<OrderByPair> orderByPairs;

    public ShowDataStmt(String dbName, String tableName, List<OrderByElement> orderByElements) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.totalRows = Lists.newArrayList();
        this.orderByElements = orderByElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.dbName);
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList<OrderByPair>();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = ShowDataStmt.analyzeColumn(slotRef.getColumnName(), this.tableName);
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
        if (this.tableName == null) {
            db.readLock();
            try {
                long totalSize = 0L;
                long totalReplicaCount = 0L;
                List<Table> tables = db.getTables();
                TreeSet<Table> sortedTables = new TreeSet<Table>(new Comparator<Table>(){

                    @Override
                    public int compare(Table t1, Table t2) {
                        return t1.getName().compareTo(t2.getName());
                    }
                });
                for (Table table : tables) {
                    if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbName, table.getName(), PrivPredicate.SHOW)) continue;
                    sortedTables.add(table);
                }
                for (Table table : sortedTables) {
                    if (table.getType() != Table.TableType.OLAP) continue;
                    OlapTable olapTable = (OlapTable)table;
                    long tableSize = 0L;
                    long replicaCount = 0L;
                    olapTable.readLock();
                    try {
                        tableSize = olapTable.getDataSize();
                        replicaCount = olapTable.getReplicaCount();
                    }
                    finally {
                        olapTable.readUnlock();
                    }
                    List<Object> row = Arrays.asList(table.getName(), tableSize, replicaCount);
                    this.totalRowsObject.add(row);
                    totalSize += tableSize;
                    totalReplicaCount += replicaCount;
                }
                if (this.orderByPairs != null && !this.orderByPairs.isEmpty()) {
                    LinkedHashMap sortMap = Maps.newLinkedHashMap();
                    for (OrderByPair orderByPair : this.orderByPairs) {
                        sortMap.put(orderByPair.getIndex(), orderByPair.isDesc());
                    }
                    this.totalRowsObject.sort(ShowDataStmt.sortRows(sortMap));
                }
                for (List list : this.totalRowsObject) {
                    Pair<Double, String> tableSizePair = DebugUtil.getByteUint((Long)list.get(1));
                    String readableSize = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(tableSizePair.first) + " " + (String)tableSizePair.second;
                    List<String> result = Arrays.asList(String.valueOf(list.get(0)), readableSize, String.valueOf(list.get(2)));
                    this.totalRows.add(result);
                }
                Pair<Double, String> totalSizePair = DebugUtil.getByteUint(totalSize);
                String string = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(totalSizePair.first) + " " + (String)totalSizePair.second;
                List<String> total = Arrays.asList("Total", string, String.valueOf(totalReplicaCount));
                this.totalRows.add(total);
                long quota = db.getDataQuota();
                long replicaQuota = db.getReplicaQuota();
                Pair<Double, String> quotaPair = DebugUtil.getByteUint(quota);
                String readableQuota = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(quotaPair.first) + " " + (String)quotaPair.second;
                List<String> quotaRow = Arrays.asList("Quota", readableQuota, String.valueOf(replicaQuota));
                this.totalRows.add(quotaRow);
                long left = Math.max(0L, quota - totalSize);
                long replicaCountLeft = Math.max(0L, replicaQuota - totalReplicaCount);
                Pair<Double, String> leftPair = DebugUtil.getByteUint(left);
                String readableLeft = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(leftPair.first) + " " + (String)leftPair.second;
                List<String> leftRow = Arrays.asList("Left", readableLeft, String.valueOf(replicaCountLeft));
                this.totalRows.add(leftRow);
            }
            finally {
                db.readUnlock();
            }
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbName, this.tableName, PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW DATA", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.dbName + ": " + this.tableName);
        }
        OlapTable olapTable = (OlapTable)db.getTableOrMetaException(this.tableName, Table.TableType.OLAP);
        int i = 0;
        long totalSize = 0L;
        long totalReplicaCount = 0L;
        olapTable.readLock();
        try {
            Map<String, Long> indexNames = olapTable.getIndexNameToId();
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            for (Map.Entry<String, Long> entry : indexNames.entrySet()) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            for (Object indexId : treeMap.values()) {
                long indexSize = 0L;
                long indexReplicaCount = 0L;
                long indexRowCount = 0L;
                for (Partition partition : olapTable.getAllPartitions()) {
                    MaterializedIndex mIndex = partition.getIndex((Long)indexId);
                    indexSize += mIndex.getDataSize();
                    indexReplicaCount += mIndex.getReplicaCount();
                    indexRowCount += mIndex.getRowCount();
                }
                String indexName = olapTable.getIndexNameById((Long)indexId);
                List<Object> row = Arrays.asList(this.tableName, indexName, indexSize, indexReplicaCount, indexRowCount);
                this.totalRowsObject.add(row);
                totalSize += indexSize;
                totalReplicaCount += indexReplicaCount;
                ++i;
            }
            if (this.orderByPairs != null && !this.orderByPairs.isEmpty()) {
                LinkedHashMap sortMap = Maps.newLinkedHashMap();
                for (OrderByPair orderByPair : this.orderByPairs) {
                    sortMap.put(orderByPair.getIndex(), orderByPair.isDesc());
                }
                this.totalRowsObject.sort(ShowDataStmt.sortRows(sortMap));
            }
            for (int index = 0; index <= this.totalRowsObject.size() - 1; ++index) {
                List<Object> row = this.totalRowsObject.get(index);
                Pair<Double, String> tableSizePair = DebugUtil.getByteUint((Long)row.get(2));
                String readableSize = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(tableSizePair.first) + " " + (String)tableSizePair.second;
                List<String> result = index == 0 ? Arrays.asList(this.tableName, String.valueOf(row.get(1)), readableSize, String.valueOf(row.get(3)), String.valueOf(row.get(4))) : Arrays.asList("", String.valueOf(row.get(1)), readableSize, String.valueOf(row.get(3)), String.valueOf(row.get(4)));
                this.totalRows.add(result);
            }
            Pair<Double, String> totalSizePair = DebugUtil.getByteUint(totalSize);
            String readableSize = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(totalSizePair.first) + " " + (String)totalSizePair.second;
            List<String> row = Arrays.asList("", "Total", readableSize, String.valueOf(totalReplicaCount), "");
            this.totalRows.add(row);
        }
        finally {
            olapTable.readUnlock();
        }
    }

    public static int analyzeColumn(String columnName, String tableName) throws AnalysisException {
        ImmutableList<String> titles = SHOW_TABLE_DATA_META_DATA_ORIGIN;
        if (tableName != null) {
            titles = SHOW_INDEX_DATA_META_DATA_ORIGIN;
        }
        for (String title : titles) {
            if (!title.equalsIgnoreCase(columnName)) continue;
            return titles.indexOf((Object)title);
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }

    private static Comparator<List<Object>> sortRows(final Map<Integer, Boolean> sortMap) {
        final Ordering ordering = Ordering.natural();
        return new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                ComparisonChain comparisonChain = ComparisonChain.start();
                for (Map.Entry sort : sortMap.entrySet()) {
                    int index = (Integer)sort.getKey();
                    boolean isDesc = (Boolean)sort.getValue();
                    comparisonChain = comparisonChain.compare(o1.get(index), o2.get(index), (Comparator)(isDesc ? ordering.reverse() : ordering));
                }
                return comparisonChain.result();
            }
        };
    }

    public boolean hasTable() {
        return this.tableName != null;
    }

    public List<List<String>> getResultRows() throws AnalysisException {
        return this.totalRows;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        if (this.tableName != null) {
            return SHOW_INDEX_DATA_META_DATA;
        }
        return SHOW_TABLE_DATA_META_DATA;
    }

    @Override
    public String toSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SHOW DATA");
        if (this.dbName == null) {
            return builder.toString();
        }
        builder.append(" FROM `").append(this.dbName).append("`");
        if (this.tableName != null) {
            builder.append(".`").append(this.tableName).append("`");
        }
        if (this.orderByElements != null) {
            builder.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                builder.append(this.orderByElements.get(i).getExpr().toSql());
                builder.append(this.orderByElements.get(i).getIsAsc() ? " ASC" : " DESC");
                builder.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

