/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowDataSkewStmt
extends ShowStmt {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BucketIdx").add((Object)"AvgDataSize").add((Object)"Graph").add((Object)"Percent").build();
    private TableRef tblRef;

    public ShowDataSkewStmt(TableRef tblRef) {
        this.tblRef = tblRef;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        PartitionNames partitionNames;
        super.analyze(analyzer);
        this.tblRef.getName().analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tblRef.getName().getDb(), this.tblRef.getName().getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW DATA SKEW", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tblRef.getName().getDb() + "." + this.tblRef.getName().getTbl());
        }
        if ((partitionNames = this.tblRef.getPartitionNames()) == null || partitionNames.getPartitionNames().size() != 1) {
            throw new AnalysisException("Should specify one and only one partition");
        }
    }

    public String getDbName() {
        return this.tblRef.getName().getDb();
    }

    public String getTblName() {
        return this.tblRef.getName().getTbl();
    }

    public PartitionNames getPartitionNames() {
        return this.tblRef.getPartitionNames();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }
}

