/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowCreateTableStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Table", ScalarType.createVarchar(20))).addColumn(new Column("Create Table", ScalarType.createVarchar(30))).build();
    private static final ShowResultSetMetaData VIEW_META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("View", ScalarType.createVarchar(20))).addColumn(new Column("Create View", ScalarType.createVarchar(30))).addColumn(new Column("character_set_client", ScalarType.createVarchar(30))).addColumn(new Column("collation_connection", ScalarType.createVarchar(30))).build();
    private TableName tbl;
    private boolean isView;

    public ShowCreateTableStmt(TableName tbl) {
        this(tbl, false);
    }

    public ShowCreateTableStmt(TableName tbl, boolean isView) {
        this.tbl = tbl;
        this.isView = isView;
    }

    public String getDb() {
        return this.tbl.getDb();
    }

    public String getTable() {
        return this.tbl.getTbl();
    }

    public boolean isView() {
        return this.isView;
    }

    public static ShowResultSetMetaData getViewMetaData() {
        return VIEW_META_DATA;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.tbl == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        this.tbl.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.tbl.getDb(), this.tbl.getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW CREATE TABLE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.tbl.getDb() + ": " + this.tbl.getTbl());
        }
    }

    @Override
    public String toSql() {
        return "SHOW CREATE TABLE " + this.tbl;
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

