/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.FunctionArgsDef;
import org.apache.doris.analysis.FunctionName;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.FunctionSearchDesc;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowCreateFunctionStmt
extends ShowStmt {
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Function Signature", ScalarType.createVarchar(256))).addColumn(new Column("Create Function", ScalarType.createVarchar(1024))).build();
    private String dbName;
    private final FunctionName functionName;
    private final FunctionArgsDef argsDef;
    private FunctionSearchDesc function;

    public ShowCreateFunctionStmt(String dbName, FunctionName functionName, FunctionArgsDef argsDef) {
        this.dbName = dbName;
        this.functionName = functionName;
        this.argsDef = argsDef;
    }

    public String getDbName() {
        return this.dbName;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public FunctionSearchDesc getFunction() {
        return this.function;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        this.functionName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), this.dbName, PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ConnectContext.get().getQualifiedUser(), this.dbName);
        }
        this.argsDef.analyze(analyzer);
        this.function = new FunctionSearchDesc(this.functionName, this.argsDef.getArgTypes(), this.argsDef.isVariadic());
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SHOW CREATE FUNCTION ").append(this.functionName).append(this.argsDef).append(" IN ").append(this.dbName);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return META_DATA;
    }
}

