/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FromClause;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowColumnStmt
extends ShowStmt {
    private static final TableName TABLE_NAME = new TableName("information_schema", "COLUMNS");
    private static final ShowResultSetMetaData META_DATA = ShowResultSetMetaData.builder().addColumn(new Column("Field", ScalarType.createVarchar(20))).addColumn(new Column("Type", ScalarType.createVarchar(20))).addColumn(new Column("Null", ScalarType.createVarchar(20))).addColumn(new Column("Key", ScalarType.createVarchar(20))).addColumn(new Column("Default", ScalarType.createVarchar(20))).addColumn(new Column("Extra", ScalarType.createVarchar(20))).build();
    private static final ShowResultSetMetaData META_DATA_VERBOSE = ShowResultSetMetaData.builder().addColumn(new Column("Field", ScalarType.createVarchar(20))).addColumn(new Column("Type", ScalarType.createVarchar(20))).addColumn(new Column("Collation", ScalarType.createVarchar(20))).addColumn(new Column("Null", ScalarType.createVarchar(20))).addColumn(new Column("Key", ScalarType.createVarchar(20))).addColumn(new Column("Default", ScalarType.createVarchar(20))).addColumn(new Column("Extra", ScalarType.createVarchar(20))).addColumn(new Column("Privileges", ScalarType.createVarchar(20))).addColumn(new Column("Comment", ScalarType.createVarchar(20))).build();
    private ShowResultSetMetaData metaData;
    private TableName tableName;
    private String db;
    private String pattern;
    private boolean isVerbose;
    private SelectStmt selectStmt;
    private Expr where;

    public ShowColumnStmt(TableName tableName, String db, String pattern, boolean isVerbose) {
        this.tableName = tableName;
        this.db = db;
        this.pattern = pattern;
        this.isVerbose = isVerbose;
    }

    public ShowColumnStmt(TableName tableName, String db, String pattern, boolean isVerbose, Expr where) {
        this.tableName = tableName;
        this.db = db;
        this.pattern = pattern;
        this.isVerbose = isVerbose;
        this.where = where;
    }

    public String getDb() {
        return this.tableName.getDb();
    }

    public String getTable() {
        return this.tableName.getTbl();
    }

    @Override
    public boolean isVerbose() {
        return this.isVerbose;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!Strings.isNullOrEmpty((String)this.db)) {
            this.tableName.setDb(this.db);
        }
        this.tableName.analyze(analyzer);
        this.metaData = this.isVerbose ? META_DATA_VERBOSE : META_DATA;
    }

    @Override
    public SelectStmt toSelectStmt(Analyzer analyzer) throws AnalysisException {
        if (this.where == null) {
            return null;
        }
        if (this.selectStmt != null) {
            return this.selectStmt;
        }
        this.analyze(analyzer);
        SelectList selectList = new SelectList();
        ExprSubstitutionMap aliasMap = new ExprSubstitutionMap();
        SelectListItem item = new SelectListItem(new SlotRef(TABLE_NAME, "COLUMN_NAME"), "Field");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Field"), item.getExpr().clone(null));
        item = new SelectListItem(new SlotRef(TABLE_NAME, "DATA_TYPE"), "Type");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Type"), item.getExpr().clone(null));
        if (this.isVerbose) {
            item = new SelectListItem(new SlotRef(TABLE_NAME, "COLLATION_NAME"), "Collation");
            selectList.addItem(item);
            aliasMap.put(new SlotRef(null, "Collation"), item.getExpr().clone(null));
        }
        item = new SelectListItem(new SlotRef(TABLE_NAME, "IS_NULLABLE"), "Null");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Null"), item.getExpr().clone(null));
        item = new SelectListItem(new SlotRef(TABLE_NAME, "COLUMN_KEY"), "Key");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Key"), item.getExpr().clone(null));
        item = new SelectListItem(new SlotRef(TABLE_NAME, "COLUMN_DEFAULT"), "Default");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Default"), item.getExpr().clone(null));
        item = new SelectListItem(new SlotRef(TABLE_NAME, "EXTRA"), "Extra");
        selectList.addItem(item);
        aliasMap.put(new SlotRef(null, "Extra"), item.getExpr().clone(null));
        if (this.isVerbose) {
            item = new SelectListItem(new SlotRef(TABLE_NAME, "PRIVILEGES"), "Privileges");
            selectList.addItem(item);
            aliasMap.put(new SlotRef(null, "Privileges"), item.getExpr().clone(null));
            item = new SelectListItem(new SlotRef(TABLE_NAME, "COLUMN_COMMENT"), "Comment");
            selectList.addItem(item);
            aliasMap.put(new SlotRef(null, "Comment"), item.getExpr().clone(null));
        }
        this.where = this.where.substitute(aliasMap);
        this.selectStmt = new SelectStmt(selectList, new FromClause(Lists.newArrayList((Object[])new TableRef[]{new TableRef(TABLE_NAME, null)})), this.where, null, null, null, LimitElement.NO_LIMIT);
        analyzer.setSchemaInfo(this.tableName.getDb(), this.tableName.getTbl(), null);
        return this.selectStmt;
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        return this.metaData;
    }
}

