/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.ImmutableList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowColumnStatsStmt
extends ShowStmt {
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"column_name").add((Object)"ndv").add((Object)"avg_size").add((Object)"max_size").add((Object)"num_nulls").add((Object)"min_value").add((Object)"max_value").build();
    private TableName tableName;

    public ShowColumnStatsStmt(TableName tableName) {
        this.tableName = tableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        this.tableName.analyze(analyzer);
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }
}

