/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.function.Predicate;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LikePredicate;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ShowResultSetMetaData;

public class ShowBackupStmt
extends ShowStmt {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobId").add((Object)"SnapshotName").add((Object)"DbName").add((Object)"State").add((Object)"BackupObjs").add((Object)"CreateTime").add((Object)"SnapshotFinishedTime").add((Object)"UploadFinishedTime").add((Object)"FinishedTime").add((Object)"UnfinishedTasks").add((Object)"Progress").add((Object)"TaskErrMsg").add((Object)"Status").add((Object)"Timeout").build();
    private String dbName;
    private final Expr where;
    private boolean isAccurateMatch;
    private String labelValue;

    public ShowBackupStmt(String dbName, Expr where) {
        this.dbName = dbName;
        this.where = where;
    }

    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), this.dbName, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ConnectContext.get().getQualifiedUser(), this.dbName);
        }
        if (this.where == null) {
            return;
        }
        boolean valid = this.analyzeWhereClause();
        if (!valid) {
            throw new AnalysisException("Where clause should like: LABEL = \"your_label_name\",  or LABEL LIKE \"matcher\"");
        }
    }

    private boolean analyzeWhereClause() {
        LikePredicate likePredicate;
        if (!(this.where instanceof LikePredicate) && !(this.where instanceof BinaryPredicate)) {
            return false;
        }
        if (this.where instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)this.where;
            if (BinaryPredicate.Operator.EQ != binaryPredicate.getOp()) {
                return false;
            }
            this.isAccurateMatch = true;
        }
        if (this.where instanceof LikePredicate && LikePredicate.Operator.LIKE != (likePredicate = (LikePredicate)this.where).getOp()) {
            return false;
        }
        if (!(this.where.getChild(0) instanceof SlotRef)) {
            return false;
        }
        String leftKey = ((SlotRef)this.where.getChild(0)).getColumnName();
        if (!"label".equalsIgnoreCase(leftKey)) {
            return false;
        }
        if (!(this.where.getChild(1) instanceof StringLiteral)) {
            return false;
        }
        this.labelValue = ((StringLiteral)this.where.getChild(1)).getStringValue();
        return !Strings.isNullOrEmpty((String)this.labelValue);
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        for (String title : TITLE_NAMES) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public String toSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("SHOW BACKUP");
        if (this.dbName != null) {
            builder.append(" FROM `").append(this.dbName).append("` ");
        }
        if (this.where != null) {
            builder.append(this.where.toSql());
        }
        return builder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }

    public boolean isAccurateMatch() {
        return this.isAccurateMatch;
    }

    public String getLabelValue() {
        return this.labelValue;
    }

    public Expr getWhere() {
        return this.where;
    }

    public Predicate<String> getLabelPredicate() throws AnalysisException {
        if (null == this.where) {
            return label -> true;
        }
        if (this.isAccurateMatch) {
            return CaseSensibility.LABEL.getCaseSensibility() ? label -> label.equals(this.labelValue) : label -> label.equalsIgnoreCase(this.labelValue);
        }
        PatternMatcher patternMatcher = PatternMatcher.createMysqlPattern(this.labelValue, CaseSensibility.LABEL.getCaseSensibility());
        return patternMatcher::match;
    }
}

