/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcService;
import org.apache.doris.common.proc.RollupProcDir;
import org.apache.doris.common.proc.SchemaChangeProcDir;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowAlterStmt
extends ShowStmt {
    private static final Logger LOG = LogManager.getLogger(ShowAlterStmt.class);
    private AlterType type;
    private String dbName;
    private Expr whereClause;
    private HashMap<String, Expr> filterMap;
    private List<OrderByElement> orderByElements;
    private ArrayList<OrderByPair> orderByPairs;
    private LimitElement limitElement;
    private ProcNodeInterface node;

    public AlterType getType() {
        return this.type;
    }

    public String getDbName() {
        return this.dbName;
    }

    public HashMap<String, Expr> getFilterMap() {
        return this.filterMap;
    }

    public LimitElement getLimitElement() {
        return this.limitElement;
    }

    public ArrayList<OrderByPair> getOrderPairs() {
        return this.orderByPairs;
    }

    public ProcNodeInterface getNode() {
        return this.node;
    }

    public ShowAlterStmt(AlterType type, String dbName, Expr whereClause, List<OrderByElement> orderByElements, LimitElement limitElement) {
        this.type = type;
        this.dbName = dbName;
        this.whereClause = whereClause;
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        this.filterMap = new HashMap();
    }

    private void getPredicateValue(Expr subExpr) throws AnalysisException {
        if (!(subExpr instanceof BinaryPredicate)) {
            throw new AnalysisException("The operator =|>=|<=|>|<|!= are supported.");
        }
        BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
        if (!(subExpr.getChild(0) instanceof SlotRef)) {
            throw new AnalysisException("Only support column = xxx syntax.");
        }
        String leftKey = ((SlotRef)subExpr.getChild(0)).getColumnName().toLowerCase();
        if (leftKey.equals("tablename") || leftKey.equals("state")) {
            if (!(subExpr.getChild(1) instanceof StringLiteral) || binaryPredicate.getOp() != BinaryPredicate.Operator.EQ) {
                throw new AnalysisException("Where clause : TableName = \"table1\" or State = \"FINISHED|CANCELLED|RUNNING|PENDING|WAITING_TXN\"");
            }
        } else if (leftKey.equals("createtime") || leftKey.equals("finishtime")) {
            if (!(subExpr.getChild(1) instanceof StringLiteral)) {
                throw new AnalysisException("Where clause : CreateTime/FinishTime =|>=|<=|>|<|!= \"2019-12-02|2019-12-02 14:54:00\"");
            }
            subExpr.setChild(1, ((StringLiteral)subExpr.getChild(1)).castTo(Type.DATETIME));
        } else {
            throw new AnalysisException("The columns of TableName/CreateTime/FinishTime/State are supported.");
        }
        this.filterMap.put(leftKey, subExpr);
    }

    private void analyzeSubPredicate(Expr subExpr) throws AnalysisException {
        if (subExpr == null) {
            return;
        }
        if (subExpr instanceof CompoundPredicate) {
            CompoundPredicate cp = (CompoundPredicate)subExpr;
            if (cp.getOp() != CompoundPredicate.Operator.AND) {
                throw new AnalysisException("Only allow compound predicate with operator AND");
            }
            this.analyzeSubPredicate((Expr)cp.getChild(0));
            this.analyzeSubPredicate((Expr)cp.getChild(1));
            return;
        }
        this.getPredicateValue(subExpr);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        this.analyzeSyntax(analyzer);
        this.handleShowAlterTable(analyzer);
    }

    public void analyzeSyntax(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            this.dbName = analyzer.getDefaultDb();
            if (Strings.isNullOrEmpty((String)this.dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
        } else {
            this.dbName = ClusterNamespace.getFullName(this.getClusterName(), this.dbName);
        }
        Preconditions.checkNotNull((Object)((Object)this.type));
        if (this.whereClause != null) {
            this.analyzeSubPredicate(this.whereClause);
        }
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            this.orderByPairs = new ArrayList();
            for (OrderByElement orderByElement : this.orderByElements) {
                if (!(orderByElement.getExpr() instanceof SlotRef)) {
                    throw new AnalysisException("Should order by column");
                }
                SlotRef slotRef = (SlotRef)orderByElement.getExpr();
                int index = SchemaChangeProcDir.analyzeColumn(slotRef.getColumnName());
                OrderByPair orderByPair = new OrderByPair(index, !orderByElement.getIsAsc());
                this.orderByPairs.add(orderByPair);
            }
        }
        if (this.limitElement != null) {
            this.limitElement.analyze(analyzer);
        }
    }

    public void handleShowAlterTable(Analyzer analyzer) throws UserException {
        Database db = analyzer.getCatalog().getDbOrAnalysisException(this.dbName);
        StringBuilder sb = new StringBuilder();
        sb.append("/jobs/");
        sb.append(db.getId());
        if (this.type == AlterType.COLUMN) {
            sb.append("/schema_change");
        } else if (this.type == AlterType.ROLLUP) {
            sb.append("/rollup");
        } else {
            throw new UserException("SHOW " + this.type.name() + " does not implement yet");
        }
        LOG.debug("process SHOW PROC '{}';", (Object)sb.toString());
        this.node = ProcService.getInstance().open(sb.toString());
        if (this.node == null) {
            throw new AnalysisException("Failed to show alter table");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SHOW ALTER TABLE ").append(this.type.name()).append(" ");
        if (!Strings.isNullOrEmpty((String)this.dbName)) {
            sb.append("FROM `").append(this.dbName).append("`");
        }
        if (this.whereClause != null) {
            sb.append(" WHERE ").append(this.whereClause.toSql());
        }
        if (this.orderByElements != null) {
            sb.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                sb.append(this.orderByElements.get(i).toSql());
                sb.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.limitElement != null) {
            sb.append(this.limitElement.toSql());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public ShowResultSetMetaData getMetaData() {
        ShowResultSetMetaData.Builder builder = ShowResultSetMetaData.builder();
        ImmutableList<String> titleNames = null;
        if (this.type == AlterType.ROLLUP) {
            titleNames = RollupProcDir.TITLE_NAMES;
        } else if (this.type == AlterType.COLUMN) {
            titleNames = SchemaChangeProcDir.TITLE_NAMES;
        }
        for (String title : titleNames) {
            builder.addColumn(new Column(title, ScalarType.createVarchar(30)));
        }
        return builder.build();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.FORWARD_NO_SYNC;
    }

    public static enum AlterType {
        COLUMN,
        ROLLUP;

    }
}

