/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.ParseUtil;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.UserResource;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.HeartbeatFlags;

public class SetVar {
    private String variable;
    private Expr value;
    private SetType type;
    private LiteralExpr result;

    public SetVar() {
    }

    public SetVar(SetType type, String variable, Expr value) {
        this.type = type;
        this.variable = variable;
        this.value = value;
        if (value instanceof LiteralExpr) {
            this.result = (LiteralExpr)value;
        }
    }

    public SetVar(String variable, Expr value) {
        this.type = SetType.DEFAULT;
        this.variable = variable;
        this.value = value;
        if (value instanceof LiteralExpr) {
            this.result = (LiteralExpr)value;
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public LiteralExpr getValue() {
        return this.result;
    }

    public SetType getType() {
        return this.type;
    }

    public void setType(SetType type) {
        this.type = type;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        String value;
        if (this.type == null) {
            this.type = SetType.DEFAULT;
        }
        if (Strings.isNullOrEmpty((String)this.variable)) {
            throw new AnalysisException("No variable name in set statement.");
        }
        if (this.type == SetType.GLOBAL && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        if (this.value == null) {
            return;
        }
        if (this.value instanceof SlotRef) {
            this.value = new StringLiteral(((SlotRef)this.value).getColumnName());
        }
        this.value.analyze(analyzer);
        if (!this.value.isConstant()) {
            throw new AnalysisException("Set statement does't support non-constant expr.");
        }
        Expr literalExpr = this.value.getResultValue();
        if (!(literalExpr instanceof LiteralExpr)) {
            throw new AnalysisException("Set statement does't support computing expr:" + literalExpr.toSql());
        }
        this.result = (LiteralExpr)literalExpr;
        if (this.variable.equalsIgnoreCase("resource_group") && this.result != null && !UserResource.isValidGroup(this.result.getStringValue())) {
            throw new AnalysisException("Invalid resource group, now we support {low, normal, high}.");
        }
        if (this.variable.equalsIgnoreCase("default_rowset_type") && this.result != null && !HeartbeatFlags.isValidRowsetType(this.result.getStringValue())) {
            throw new AnalysisException("Invalid rowset type, now we support {alpha, beta}.");
        }
        if (this.getVariable().equalsIgnoreCase("prefer_join_method") && !(value = this.getValue().getStringValue()).equalsIgnoreCase("broadcast") && !value.equalsIgnoreCase("shuffle")) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "prefer_join_method", value);
        }
        if (this.getVariable().equalsIgnoreCase("time_zone")) {
            this.value = new StringLiteral(TimeUtils.checkTimeZoneValidAndStandardize(this.getValue().getStringValue()));
            this.result = (LiteralExpr)this.value;
        }
        if (this.getVariable().equalsIgnoreCase("exec_mem_limit")) {
            this.value = new StringLiteral(Long.toString(ParseUtil.analyzeDataVolumn(this.getValue().getStringValue())));
            this.result = (LiteralExpr)this.value;
        }
        if (this.getVariable().equalsIgnoreCase("is_report_success")) {
            this.variable = "enable_profile";
        }
        if (this.getVariable().equalsIgnoreCase("partition_prune_algorithm_version") && !"1".equals(value = this.getValue().getStringValue()) && !"2".equals(value)) {
            throw new AnalysisException("Value of partition_prune_algorithm_version should be either 1 or 2, but meet " + value);
        }
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toSql());
        sb.append(" ").append(this.variable).append(" = ").append(this.value.toSql());
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

