/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.UserProperty;
import org.apache.doris.qe.ConnectContext;

public class SetUserPropertyVar
extends SetVar {
    public static final String DOT_SEPARATOR = ".";
    private final String key;
    private final String value;

    public SetUserPropertyVar(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getPropertyKey() {
        return this.key;
    }

    public String getPropertyValue() {
        return this.value;
    }

    public void analyze(Analyzer analyzer, boolean isSelf) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.key)) {
            throw new AnalysisException("User property key is null");
        }
        if (this.value == null) {
            throw new AnalysisException("User property value is null");
        }
        this.checkAccess(analyzer, isSelf);
    }

    private void checkAccess(Analyzer analyzer, boolean isSelf) throws AnalysisException {
        Matcher matcher;
        for (Pattern advPattern : UserProperty.ADVANCED_PROPERTIES) {
            matcher = advPattern.matcher(this.key);
            if (!matcher.find()) continue;
            if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
            }
            return;
        }
        for (Pattern commPattern : UserProperty.COMMON_PROPERTIES) {
            matcher = commPattern.matcher(this.key);
            if (!matcher.find()) continue;
            if (!isSelf && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
            }
            return;
        }
        throw new AnalysisException("Unknown property key: " + this.key);
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(this.key);
        sb.append("' = ");
        if (this.value != null) {
            sb.append("'");
            sb.append(this.value);
            sb.append("'");
        } else {
            sb.append("NULL");
        }
        return sb.toString();
    }
}

