/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.SetUserPropertyVar;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.ConnectContext;

public class SetUserPropertyStmt
extends DdlStmt {
    private String user;
    private final List<SetVar> propertyList;

    public SetUserPropertyStmt(String user, List<SetVar> propertyList) {
        this.user = user;
        this.propertyList = propertyList;
    }

    public String getUser() {
        return this.user;
    }

    public List<Pair<String, String>> getPropertyPairList() {
        ArrayList list = Lists.newArrayList();
        for (SetVar var : this.propertyList) {
            list.add(Pair.create(((SetUserPropertyVar)var).getPropertyKey(), ((SetUserPropertyVar)var).getPropertyValue()));
        }
        return list;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.user)) {
            this.user = ConnectContext.get().getQualifiedUser();
        } else if (!this.user.equals("root") && !this.user.equals("admin")) {
            this.user = ClusterNamespace.getFullName(this.getClusterName(), this.user);
        }
        if (this.propertyList == null || this.propertyList.isEmpty()) {
            throw new AnalysisException("Empty properties");
        }
        boolean isSelf = this.user.equals(ConnectContext.get().getQualifiedUser());
        for (SetVar var : this.propertyList) {
            ((SetUserPropertyVar)var).analyze(analyzer, isSelf);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SET PROPERTY FOR '");
        sb.append(this.user);
        sb.append("' ");
        int idx = 0;
        for (SetVar var : this.propertyList) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append(var.toSql());
            ++idx;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

