/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.SetPassVar;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;

public class SetStmt
extends StatementBase {
    private final List<SetVar> setVars;

    public SetStmt(List<SetVar> setVars) {
        this.setVars = setVars;
    }

    public List<SetVar> getSetVars() {
        return this.setVars;
    }

    @Override
    public boolean needAuditEncryption() {
        for (SetVar var : this.setVars) {
            if (!(var instanceof SetPassVar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (this.setVars == null || this.setVars.isEmpty()) {
            throw new AnalysisException("Empty set statement.");
        }
        for (SetVar var : this.setVars) {
            var.analyze(analyzer);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("SET ");
        int idx = 0;
        for (SetVar var : this.setVars) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append(var.toSql());
            ++idx;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        if (this.setVars != null) {
            for (SetVar var : this.setVars) {
                if (var instanceof SetPassVar) {
                    return RedirectStatus.FORWARD_WITH_SYNC;
                }
                if (var.getType() != SetType.GLOBAL) continue;
                return RedirectStatus.FORWARD_WITH_SYNC;
            }
        }
        return RedirectStatus.NO_FORWARD;
    }
}

