/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.MysqlPassword;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class SetPassVar
extends SetVar {
    private UserIdentity userIdent;
    private String passwdParam;
    private byte[] passwdBytes;

    public SetPassVar(UserIdentity userIdent, String passwd) {
        this.userIdent = userIdent;
        this.passwdParam = passwd;
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    public byte[] getPassword() {
        return this.passwdBytes;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_SELECT_CLUSTER, new Object[0]);
        }
        boolean isSelf = false;
        ConnectContext ctx = ConnectContext.get();
        if (this.userIdent == null) {
            this.userIdent = ctx.getCurrentUserIdentity();
            isSelf = true;
        } else {
            this.userIdent.analyze(analyzer.getClusterName());
            if (this.userIdent.equals(ctx.getCurrentUserIdentity())) {
                isSelf = true;
            }
        }
        this.passwdBytes = MysqlPassword.checkPassword(this.passwdParam);
        if (isSelf) {
            return;
        }
        if (this.userIdent.getQualifiedUser().equals("root") && !ClusterNamespace.getNameFromFullName(ctx.getQualifiedUser()).equals("root")) {
            throw new AnalysisException("Can not set password for root user, except root itself");
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "GRANT");
        }
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SET PASSWORD");
        if (this.userIdent != null) {
            sb.append(" FOR ").append(this.userIdent.toString());
        }
        sb.append(" = '*XXX'");
        return sb.toString();
    }
}

