/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetOperationStmt
extends QueryStmt {
    private static final Logger LOG = LogManager.getLogger(SetOperationStmt.class);
    private final List<SetOperand> operands;
    protected final List<SetOperand> distinctOperands_ = Lists.newArrayList();
    protected final List<SetOperand> allOperands_ = Lists.newArrayList();
    private AggregateInfo distinctAggInfo;
    private boolean hasDistinct = false;
    private TupleId tupleId;
    private String toSqlString;
    private boolean hasAnalyticExprs_ = false;
    private List<Expr> setOpsResultExprs_ = Lists.newArrayList();

    public SetOperationStmt(List<SetOperand> operands, ArrayList<OrderByElement> orderByElements, LimitElement limitElement) {
        super(orderByElements, limitElement);
        this.operands = operands;
    }

    protected SetOperationStmt(SetOperationStmt other) {
        super(other.cloneOrderByElements(), other.limitElement == null ? null : other.limitElement.clone());
        this.operands = Lists.newArrayList();
        if (this.analyzer != null) {
            for (SetOperand o : other.distinctOperands_) {
                this.distinctOperands_.add(o.clone());
            }
            for (SetOperand o : other.allOperands_) {
                this.allOperands_.add(o.clone());
            }
            this.operands.addAll(this.distinctOperands_);
            this.operands.addAll(this.allOperands_);
        } else {
            for (SetOperand operand : other.operands) {
                this.operands.add(operand.clone());
            }
        }
        this.analyzer = other.analyzer;
        this.distinctAggInfo = other.distinctAggInfo != null ? other.distinctAggInfo.clone() : null;
        this.tupleId = other.tupleId;
        this.toSqlString = other.toSqlString != null ? new String(other.toSqlString) : null;
        this.hasAnalyticExprs_ = other.hasAnalyticExprs_;
        this.withClause_ = other.withClause_ != null ? other.withClause_.clone() : null;
        this.setOpsResultExprs_ = Expr.cloneList(other.setOpsResultExprs_);
    }

    @Override
    public SetOperationStmt clone() {
        return new SetOperationStmt(this);
    }

    @Override
    public void reset() {
        super.reset();
        for (SetOperand op : this.operands) {
            op.reset();
        }
        this.distinctOperands_.clear();
        this.allOperands_.clear();
        this.distinctAggInfo = null;
        this.tupleId = null;
        this.toSqlString = null;
        this.hasAnalyticExprs_ = false;
        this.setOpsResultExprs_.clear();
    }

    @Override
    public void resetSelectList() {
        for (SetOperand operand : this.operands) {
            operand.getQueryStmt().resetSelectList();
        }
    }

    public List<SetOperand> getOperands() {
        return this.operands;
    }

    public List<SetOperand> getDistinctOperands() {
        return this.distinctOperands_;
    }

    public boolean hasDistinctOps() {
        return !this.distinctOperands_.isEmpty();
    }

    public List<SetOperand> getAllOperands() {
        return this.allOperands_;
    }

    public boolean hasAllOps() {
        return !this.allOperands_.isEmpty();
    }

    public AggregateInfo getDistinctAggInfo() {
        return this.distinctAggInfo;
    }

    public boolean hasAnalyticExprs() {
        return this.hasAnalyticExprs_;
    }

    public TupleId getTupleId() {
        return this.tupleId;
    }

    public void removeAllOperands() {
        this.operands.removeAll(this.allOperands_);
        this.allOperands_.clear();
    }

    public List<Expr> getSetOpsResultExprs() {
        return this.setOpsResultExprs_;
    }

    @Override
    public void getTables(Analyzer analyzer, Map<Long, Table> tableMap, Set<String> parentViewNameSet) throws AnalysisException {
        this.getWithClauseTables(analyzer, tableMap, parentViewNameSet);
        for (SetOperand op : this.operands) {
            op.getQueryStmt().getTables(analyzer, tableMap, parentViewNameSet);
        }
    }

    @Override
    public void getTableRefs(Analyzer analyzer, List<TableRef> tblRefs, Set<String> parentViewNameSet) {
        this.getWithClauseTableRefs(analyzer, tblRefs, parentViewNameSet);
        for (SetOperand op : this.operands) {
            op.getQueryStmt().getTableRefs(analyzer, tblRefs, parentViewNameSet);
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        Preconditions.checkState((this.operands.size() > 0 ? 1 : 0) != 0);
        if (this.operands.get(0).operation == null && this.operands.size() > 1) {
            this.operands.get(0).setOperation(this.operands.get(1).getOperation());
        }
        this.propagateDistinct();
        this.analyzeOperands(analyzer);
        if (this.needToSql) {
            this.toSqlString = this.toSql();
        }
        this.unnestOperands(analyzer);
        this.hasAnalyticExprs_ = false;
        for (SetOperand setOperand : this.operands) {
            if (!setOperand.hasAnalyticExprs()) continue;
            this.hasAnalyticExprs_ = true;
            break;
        }
        ArrayList resultExprLists = Lists.newArrayList();
        for (SetOperand op : this.operands) {
            resultExprLists.add(op.getQueryStmt().getResultExprs());
        }
        analyzer.castToSetOpsCompatibleTypes(resultExprLists);
        this.createMetadata(analyzer);
        this.createSortInfo(analyzer);
        for (SetOperand operand : this.operands) {
            this.setOperandSmap(operand, analyzer);
        }
        if (!this.distinctOperands_.isEmpty()) {
            ArrayList<Expr> arrayList = Expr.cloneList(this.resultExprs);
            try {
                this.distinctAggInfo = AggregateInfo.create(arrayList, null, analyzer.getDescTbl().getTupleDesc(this.tupleId), analyzer);
            }
            catch (AnalysisException e) {
                throw new IllegalStateException("Error creating agg info in SetOperationStmt.analyze()", e);
            }
        }
        this.setOpsResultExprs_ = Expr.cloneList(this.resultExprs);
        if (this.evaluateOrderBy) {
            this.createSortTupleInfo(analyzer);
        }
        this.baseTblResultExprs = this.resultExprs;
        if (this.hasOutFileClause()) {
            this.outFileClause.analyze(analyzer, this.resultExprs);
        }
    }

    private void analyzeOperands(Analyzer analyzer) throws AnalysisException, UserException {
        for (int i = 0; i < this.operands.size(); ++i) {
            this.operands.get(i).analyze(analyzer);
            QueryStmt firstQuery = this.operands.get(0).getQueryStmt();
            List firstExprs = this.operands.get(0).getQueryStmt().getResultExprs();
            QueryStmt query = this.operands.get(i).getQueryStmt();
            List exprs = query.getResultExprs();
            if (firstExprs.size() == exprs.size()) continue;
            throw new AnalysisException("Operands have unequal number of columns:\n'" + this.queryStmtToSql(firstQuery) + "' has " + firstExprs.size() + " column(s)\n'" + this.queryStmtToSql(query) + "' has " + exprs.size() + " column(s)");
        }
    }

    private void unnestOperands(Analyzer analyzer) throws AnalysisException {
        int i;
        if (this.operands.size() == 1) {
            this.allOperands_.add(this.operands.get(0));
            return;
        }
        int firstAllIdx = this.operands.size();
        for (i = 1; i < this.operands.size(); ++i) {
            SetOperand operand = this.operands.get(i);
            if (operand.getQualifier() != Qualifier.ALL) continue;
            firstAllIdx = i == 1 ? 0 : i;
            break;
        }
        Preconditions.checkState((firstAllIdx != 1 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.distinctOperands_.isEmpty());
        for (i = 0; i < firstAllIdx; ++i) {
            this.unnestOperand(this.distinctOperands_, Qualifier.DISTINCT, this.operands.get(i));
        }
        Preconditions.checkState((boolean)this.allOperands_.isEmpty());
        for (i = firstAllIdx; i < this.operands.size(); ++i) {
            this.unnestOperand(this.allOperands_, Qualifier.ALL, this.operands.get(i));
        }
        for (SetOperand op : this.distinctOperands_) {
            op.setQualifier(Qualifier.DISTINCT);
        }
        for (SetOperand op : this.allOperands_) {
            op.setQualifier(Qualifier.ALL);
        }
        this.operands.clear();
        this.operands.addAll(this.distinctOperands_);
        this.operands.addAll(this.allOperands_);
    }

    private void unnestOperand(List<SetOperand> target, Qualifier targetQualifier, SetOperand operand) {
        Preconditions.checkState((boolean)operand.isAnalyzed());
        QueryStmt queryStmt = operand.getQueryStmt();
        if (queryStmt instanceof SelectStmt) {
            target.add(operand);
            return;
        }
        Preconditions.checkState((boolean)(queryStmt instanceof SetOperationStmt));
        SetOperationStmt setOperationStmt = (SetOperationStmt)queryStmt;
        boolean mixed = false;
        if (operand.getOperation() != null) {
            for (int i = 1; i < setOperationStmt.operands.size(); ++i) {
                if (operand.getOperation() == setOperationStmt.operands.get(i).getOperation()) continue;
                mixed = true;
                break;
            }
        }
        if (setOperationStmt.hasLimit() || setOperationStmt.hasOffset() || mixed) {
            target.add(operand);
        } else if (targetQualifier == Qualifier.DISTINCT || !setOperationStmt.hasDistinctOps()) {
            target.addAll(setOperationStmt.getDistinctOperands());
            target.addAll(setOperationStmt.getAllOperands());
        } else {
            target.addAll(setOperationStmt.getAllOperands());
            setOperationStmt.removeAllOperands();
            target.add(operand);
        }
    }

    private void setOperandSmap(SetOperand operand, Analyzer analyzer) {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().getTupleDesc(this.tupleId);
        operand.getSmap().clear();
        List resultExprs = operand.getQueryStmt().getResultExprs();
        Preconditions.checkState((resultExprs.size() == tupleDesc.getSlots().size() ? 1 : 0) != 0);
        for (int i = 0; i < tupleDesc.getSlots().size(); ++i) {
            SlotDescriptor outputSlot = tupleDesc.getSlots().get(i);
            Expr origExpr = ((Expr)resultExprs.get(i)).unwrapExpr(true).clone();
            operand.getSmap().put(new SlotRef(outputSlot), origExpr);
        }
    }

    protected String queryStmtToSql(QueryStmt queryStmt) {
        return queryStmt.toSql();
    }

    private void propagateDistinct() {
        int firstDistinctPos = -1;
        for (int i = this.operands.size() - 1; i > 0; --i) {
            SetOperand operand = this.operands.get(i);
            if (firstDistinctPos != -1) {
                operand.setQualifier(Qualifier.DISTINCT);
                continue;
            }
            if (operand.getQualifier() != Qualifier.DISTINCT) continue;
            firstDistinctPos = i;
        }
    }

    private void createMetadata(Analyzer analyzer) throws AnalysisException {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().createTupleDescriptor("SetOps");
        tupleDesc.setIsMaterialized(true);
        this.tupleId = tupleDesc.getId();
        if (LOG.isTraceEnabled()) {
            LOG.trace("SetOperationStmt.createMetadata: tupleId=" + this.tupleId.toString());
        }
        List firstSelectExprs = this.operands.get(0).getQueryStmt().getResultExprs();
        for (int i = 0; i < firstSelectExprs.size(); ++i) {
            Expr expr = (Expr)firstSelectExprs.get(i);
            SlotDescriptor slotDesc = analyzer.addSlotDescriptor(tupleDesc);
            slotDesc.setLabel((String)((ArrayList)this.getColLabels()).get(i));
            slotDesc.setType(expr.getType());
            slotDesc.setIsNullable(expr.isNullable());
            SlotRef outputSlotRef = new SlotRef(slotDesc);
            this.resultExprs.add(outputSlotRef);
            if (this.orderByElements != null) {
                SlotRef aliasRef = new SlotRef(null, (String)((ArrayList)this.getColLabels()).get(i));
                if (this.aliasSMap.containsMappingFor(aliasRef)) {
                    this.ambiguousAliasList.add(aliasRef);
                } else {
                    this.aliasSMap.put(aliasRef, outputSlotRef);
                }
            }
            boolean isNullable = false;
            for (SetOperand op : this.operands) {
                Expr resultExpr = (Expr)((ArrayList)op.getQueryStmt().getResultExprs()).get(i);
                slotDesc.addSourceExpr(resultExpr);
                SlotRef slotRef = resultExpr.unwrapSlotRef(false);
                if (slotRef == null) {
                    isNullable |= resultExpr.isNullable();
                } else if (slotRef.getDesc().getIsNullable() || analyzer.isOuterJoined(slotRef.getDesc().getParent().getId())) {
                    isNullable = true;
                }
                if (!op.hasAnalyticExprs() && (slotRef = resultExpr.unwrapSlotRef(true)) != null) continue;
            }
            slotDesc.setIsNullable(isNullable);
        }
        this.baseTblResultExprs = this.resultExprs;
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer) throws AnalysisException {
        TupleDescriptor tupleDesc = analyzer.getDescTbl().getTupleDesc(this.tupleId);
        if (!this.distinctOperands_.isEmpty()) {
            tupleDesc.materializeSlots();
        }
        if (this.evaluateOrderBy) {
            this.sortInfo.materializeRequiredSlots(analyzer, null);
        }
        ArrayList<SlotDescriptor> outputSlots = tupleDesc.getSlots();
        ArrayList exprs = Lists.newArrayList();
        for (int i = 0; i < outputSlots.size(); ++i) {
            SlotDescriptor slotDesc = (SlotDescriptor)outputSlots.get(i);
            if (!slotDesc.isMaterialized()) continue;
            for (SetOperand op : this.operands) {
                exprs.add(op.getQueryStmt().getBaseTblResultExprs().get(i));
            }
            if (this.distinctAggInfo == null) continue;
            this.distinctAggInfo.getOutputTupleDesc().getSlots().get(i).setIsMaterialized(true);
        }
        this.materializeSlots(analyzer, exprs);
        for (SetOperand op : this.operands) {
            op.getQueryStmt().materializeRequiredSlots(analyzer);
        }
    }

    @Override
    public void collectExprs(Map<String, Expr> exprMap) {
        for (SetOperand op : this.operands) {
            op.getQueryStmt().collectExprs(exprMap);
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElement : this.orderByElementsAfterAnalyzed) {
                Expr expr = orderByElement.getExpr();
                if (this.containAlias(expr)) continue;
                this.registerExprId(expr);
                exprMap.put(expr.getId().toString(), expr);
            }
        }
    }

    @Override
    public void putBackExprs(Map<String, Expr> rewrittenExprMap) {
        for (SetOperand op : this.operands) {
            op.getQueryStmt().putBackExprs(rewrittenExprMap);
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElement : this.orderByElementsAfterAnalyzed) {
                Expr expr = orderByElement.getExpr();
                if (expr.getId() == null) {
                    orderByElement.setExpr(expr);
                    continue;
                }
                orderByElement.setExpr(rewrittenExprMap.get(expr.getId().toString()));
            }
            this.orderByElements = (ArrayList)this.orderByElementsAfterAnalyzed;
        }
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        for (SetOperand op : this.operands) {
            op.getQueryStmt().rewriteExprs(rewriter);
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElem : this.orderByElements) {
                orderByElem.setExpr(rewriter.rewrite(orderByElem.getExpr(), this.analyzer));
            }
        }
    }

    @Override
    public void getMaterializedTupleIds(ArrayList<TupleId> tupleIdList) {
        if (this.evaluateOrderBy) {
            tupleIdList.add(this.sortInfo.getSortTupleDescriptor().getId());
        } else {
            tupleIdList.add(this.tupleId);
        }
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        for (SetOperand op : this.operands) {
            op.getQueryStmt().collectTableRefs(tblRefs);
        }
    }

    @Override
    public List<TupleId> collectTupleIds() {
        ArrayList result = Lists.newArrayList();
        for (SetOperand op : this.operands) {
            result.addAll(op.getQueryStmt().collectTupleIds());
        }
        return result;
    }

    @Override
    public String toSql() {
        if (this.toSqlString != null) {
            return this.toSqlString;
        }
        StringBuilder strBuilder = new StringBuilder();
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql());
            strBuilder.append(" ");
        }
        Preconditions.checkState((this.operands.size() > 0 ? 1 : 0) != 0);
        strBuilder.append(this.operands.get(0).getQueryStmt().toSql());
        for (int i = 1; i < this.operands.size() - 1; ++i) {
            strBuilder.append(" " + this.operands.get(i).getOperation().toString() + " " + (this.operands.get(i).getQualifier() == Qualifier.ALL ? "ALL " : ""));
            if (this.operands.get(i).getQueryStmt() instanceof SetOperationStmt) {
                strBuilder.append("(");
            }
            strBuilder.append(this.operands.get(i).getQueryStmt().toSql());
            if (!(this.operands.get(i).getQueryStmt() instanceof SetOperationStmt)) continue;
            strBuilder.append(")");
        }
        SetOperand lastOperand = this.operands.get(this.operands.size() - 1);
        QueryStmt lastQueryStmt = lastOperand.getQueryStmt();
        strBuilder.append(" " + lastOperand.getOperation().toString() + " " + (lastOperand.getQualifier() == Qualifier.ALL ? "ALL " : ""));
        if (lastQueryStmt instanceof SetOperationStmt || (this.hasOrderByClause() || this.hasLimitClause()) && !lastQueryStmt.hasLimitClause() && !lastQueryStmt.hasOrderByClause()) {
            strBuilder.append("(");
            strBuilder.append(lastQueryStmt.toSql());
            strBuilder.append(")");
        } else {
            strBuilder.append(lastQueryStmt.toSql());
        }
        if (this.hasOrderByClause()) {
            strBuilder.append(" ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                strBuilder.append(((OrderByElement)this.orderByElements.get(i)).getExpr().toSql());
                strBuilder.append(((OrderByElement)this.orderByElements.get(i)).getIsAsc() ? " ASC" : " DESC");
                strBuilder.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.hasLimitClause()) {
            strBuilder.append(this.limitElement.toSql());
        }
        return strBuilder.toString();
    }

    @Override
    public ArrayList<String> getColLabels() {
        Preconditions.checkState((this.operands.size() > 0 ? 1 : 0) != 0);
        return this.operands.get(0).getQueryStmt().getColLabels();
    }

    @Override
    public void setNeedToSql(boolean needToSql) {
        super.setNeedToSql(needToSql);
        for (SetOperand operand : this.operands) {
            operand.getQueryStmt().setNeedToSql(needToSql);
        }
    }

    @Override
    public void substituteSelectList(Analyzer analyzer, List<String> newColLabels) throws AnalysisException, UserException {
        QueryStmt firstQuery = this.operands.get(0).getQueryStmt();
        firstQuery.substituteSelectList(analyzer, newColLabels);
        if (this.orderByElements != null) {
            this.orderByElements = OrderByElement.substitute(this.orderByElements, firstQuery.aliasSMap, analyzer);
        }
    }

    public static class SetOperand {
        private Operation operation;
        private Qualifier qualifier_;
        private QueryStmt queryStmt;
        private Analyzer analyzer;
        private final ExprSubstitutionMap smap_;

        public SetOperand(QueryStmt queryStmt, Operation operation, Qualifier qualifier) {
            this.queryStmt = queryStmt;
            this.operation = operation;
            this.qualifier_ = qualifier;
            this.smap_ = new ExprSubstitutionMap();
        }

        public void analyze(Analyzer parent) throws AnalysisException, UserException {
            if (this.isAnalyzed()) {
                return;
            }
            if (this.operation != Operation.UNION && this.queryStmt instanceof SelectStmt && ((SelectStmt)this.queryStmt).fromClause_.isEmpty()) {
                QueryStmt inlineQuery = this.queryStmt.clone();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (int i = 0; i < ((SelectStmt)inlineQuery).selectList.getItems().size(); ++i) {
                    SelectListItem item = ((SelectStmt)inlineQuery).selectList.getItems().get(i);
                    String col = item.toColumnLabel();
                    Integer count = (Integer)map.get(col);
                    count = count == null ? 1 : count + 1;
                    map.put(col, count);
                    if (count <= 1) continue;
                    ((SelectStmt)inlineQuery).selectList.getItems().set(i, new SelectListItem(item.getExpr(), col + "_" + count.toString()));
                }
                ((SelectStmt)this.queryStmt).fromClause_.add(new InlineViewRef("__DORIS_DUAL__", inlineQuery));
                List<SelectListItem> slist = ((SelectStmt)this.queryStmt).selectList.getItems();
                slist.clear();
                slist.add(SelectListItem.createStarItem(null));
            }
            if (this.qualifier_ == Qualifier.ALL && (this.operation == Operation.EXCEPT || this.operation == Operation.INTERSECT)) {
                throw new AnalysisException("INTERSECT and EXCEPT does not support ALL qualifier.");
            }
            this.analyzer = new Analyzer(parent);
            this.queryStmt.analyze(this.analyzer);
        }

        public boolean isAnalyzed() {
            return this.analyzer != null;
        }

        public QueryStmt getQueryStmt() {
            return this.queryStmt;
        }

        public Qualifier getQualifier() {
            return this.qualifier_;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setQualifier(Qualifier qualifier) {
            this.qualifier_ = qualifier;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public void setQueryStmt(QueryStmt queryStmt) {
            this.queryStmt = queryStmt;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public ExprSubstitutionMap getSmap() {
            return this.smap_;
        }

        public boolean hasAnalyticExprs() {
            if (this.queryStmt instanceof SelectStmt) {
                return ((SelectStmt)this.queryStmt).hasAnalyticInfo();
            }
            Preconditions.checkState((boolean)(this.queryStmt instanceof SetOperationStmt));
            return ((SetOperationStmt)this.queryStmt).hasAnalyticExprs();
        }

        private SetOperand(SetOperand other) {
            this.queryStmt = other.queryStmt.clone();
            this.operation = other.operation;
            this.qualifier_ = other.qualifier_;
            this.analyzer = other.analyzer;
            this.smap_ = other.smap_.clone();
        }

        public void reset() {
            this.queryStmt.reset();
            this.analyzer = null;
            this.smap_.clear();
        }

        public SetOperand clone() {
            return new SetOperand(this);
        }
    }

    public static enum Qualifier {
        ALL,
        DISTINCT;

    }

    public static enum Operation {
        UNION,
        INTERSECT,
        EXCEPT;

    }
}

