/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;

public class SetNamesVar
extends SetVar {
    private static final String DEFAULT_NAMES = "utf8";
    private String charset;
    private String collate;

    public SetNamesVar(String charsetName) {
        this(charsetName, (String)null);
    }

    public SetNamesVar(String charsetName, String collate) {
        this.charset = charsetName;
        this.collate = collate;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.charset = Strings.isNullOrEmpty((String)this.charset) ? DEFAULT_NAMES : this.charset.toLowerCase();
        if (this.charset.startsWith(DEFAULT_NAMES)) {
            this.charset = DEFAULT_NAMES;
        }
        if (!this.charset.equalsIgnoreCase(DEFAULT_NAMES)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_CHARACTER_SET, this.charset);
        }
    }

    @Override
    public String toSql() {
        return "NAMES '" + this.charset + "' COLLATE " + (Strings.isNullOrEmpty((String)this.collate) ? "DEFAULT" : "'" + this.collate.toLowerCase() + "'");
    }

    @Override
    public String toString() {
        return this.toSql();
    }
}

