/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.qe.ConnectContext;

public class SetLdapPassVar
extends SetVar {
    private final String passwd;

    public SetLdapPassVar(String passwd) {
        this.passwd = passwd;
    }

    public String getLdapPassword() {
        return this.passwd;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)analyzer.getClusterName())) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_SELECT_CLUSTER, new Object[0]);
        }
        if (!ConnectContext.get().getCurrentUserIdentity().getQualifiedUser().equals("root") && !ConnectContext.get().getCurrentUserIdentity().getQualifiedUser().equals("admin")) {
            throw new AnalysisException("Only root and admin user can set ldap admin password.");
        }
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder("SET LDAP_ADMIN_PASSWORD");
        sb.append(" = '*XXX'");
        return sb.toString();
    }
}

